/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.xml;

import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dellroad.stuff.xml.StreamWriterDelegate;

public class IndentXMLStreamWriter
extends StreamWriterDelegate {
    public static final String DEFAULT_VERSION = "1.0";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final int DEFAULT_INDENT = 4;
    private final String newline = System.getProperty("line.separator", "\\n");
    private final StringBuilder whitespaceBuffer = new StringBuilder();
    private final int indent;
    private boolean addMissingXmlDeclaration = true;
    private boolean indentAfterXmlDeclaration = true;
    private String defaultVersion = "1.0";
    private String defaultEncoding = "UTF-8";
    private boolean started;
    private int lastEvent = -1;
    private int depth;

    public IndentXMLStreamWriter() {
        this.indent = 4;
    }

    public IndentXMLStreamWriter(XMLStreamWriter writer) {
        this(writer, 4);
    }

    public IndentXMLStreamWriter(XMLStreamWriter writer, int indent) {
        super(writer);
        this.indent = indent;
    }

    public void setAddMissingXmlDeclaration(boolean addMissingXmlDeclaration) {
        this.addMissingXmlDeclaration = addMissingXmlDeclaration;
    }

    public void setIndentAfterXmlDeclaration(boolean indentAfterXmlDeclaration) {
        this.indentAfterXmlDeclaration = indentAfterXmlDeclaration;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        if (this.started) {
            return;
        }
        this.started = true;
        this.handleOther(7);
        super.writeStartDocument(encoding, version);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument(this.defaultEncoding, version);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(this.defaultEncoding, this.defaultVersion);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.handleStartElement(false);
        super.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.handleStartElement(false);
        super.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String namespaceURI, String localName) throws XMLStreamException {
        this.handleStartElement(false);
        super.writeStartElement(prefix, namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.handleStartElement(true);
        super.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String namespaceURI, String localName) throws XMLStreamException {
        this.handleStartElement(true);
        super.writeEmptyElement(prefix, namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.handleStartElement(true);
        super.writeEmptyElement(localName);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.handleOther(5);
        super.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.handleOther(3);
        super.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.handleOther(3);
        super.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.handleOther(12);
        super.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.handleOther(11);
        super.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.handleOther(9);
        super.writeEntityRef(name);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.handleCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writeCharacters(new String(text, start, len));
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        while (this.depth > 0) {
            this.writeEndElement();
            --this.depth;
        }
        super.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        --this.depth;
        if (this.lastEvent == 2) {
            this.indent();
        }
        this.handleOther(2);
        super.writeEndElement();
    }

    private void handleStartElement(boolean selfClosing) throws XMLStreamException {
        this.writeStartDocumentIfNecessary();
        if (this.lastEvent == 1 || this.lastEvent == 2 || this.indentAfterXmlDeclaration && this.lastEvent == 7) {
            this.indent();
        }
        this.handleOther(selfClosing ? 2 : 1);
        if (!selfClosing) {
            ++this.depth;
        }
    }

    private void handleCharacters(String text) throws XMLStreamException {
        this.writeStartDocumentIfNecessary();
        if ((this.lastEvent == 1 || this.lastEvent == 2) && text.trim().length() == 0) {
            this.whitespaceBuffer.append(text);
        } else {
            this.handleOther(4);
            super.writeCharacters(text);
        }
    }

    private void handleOther(int eventType) throws XMLStreamException {
        this.writeStartDocumentIfNecessary();
        if (this.whitespaceBuffer.length() > 0) {
            super.writeCharacters(this.whitespaceBuffer.toString());
            this.whitespaceBuffer.setLength(0);
        }
        this.lastEvent = eventType;
    }

    private void writeStartDocumentIfNecessary() throws XMLStreamException {
        if (!this.started && this.addMissingXmlDeclaration) {
            this.writeStartDocument();
        }
    }

    private void indent() {
        if (this.indent < 0) {
            this.whitespaceBuffer.setLength(0);
            return;
        }
        int newlines = 0;
        int i = 0;
        while (i < this.whitespaceBuffer.length() && (this.whitespaceBuffer.charAt(i) == '\n' || this.whitespaceBuffer.charAt(i++) == '\r' && i < this.whitespaceBuffer.length() && this.whitespaceBuffer.charAt(i) == '\n')) {
            ++newlines;
            ++i;
        }
        this.whitespaceBuffer.setLength(0);
        newlines = Math.max(newlines, 1);
        char[] buf = new char[newlines + Math.max(this.depth, 0) * this.indent];
        Arrays.fill(buf, 0, newlines, '\n');
        Arrays.fill(buf, newlines, buf.length, ' ');
        this.whitespaceBuffer.append(buf);
    }
}

