/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.xml;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;

public class TransformErrorListener
implements ErrorListener {
    protected final Logger log;
    protected final boolean xalanWorkarounds;

    public TransformErrorListener(Logger log, boolean xalanWorkarounds) {
        this.log = log;
        this.xalanWorkarounds = xalanWorkarounds;
    }

    @Override
    public void warning(TransformerException e) throws TransformerException {
        this.log.warn(this.getLogMessageFor(e));
        if (this.xalanWorkarounds) {
            this.rethrow(e);
        }
    }

    @Override
    public void error(TransformerException e) throws TransformerException {
        this.log.error(this.getLogMessageFor(e));
        this.rethrow(e);
    }

    @Override
    public void fatalError(TransformerException e) throws TransformerException {
        this.log.error(this.getLogMessageFor(e));
        this.rethrow(e);
    }

    protected String getLogMessageFor(TransformerException e) {
        return e.getMessageAndLocation();
    }

    protected void rethrow(TransformerException e) throws TransformerException {
        if (!this.xalanWorkarounds) {
            throw e;
        }
        throw new RuntimeException("exception from XSL transform", e);
    }
}

