/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.servlet;

import java.io.IOException;
import java.net.SocketException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class ExceptionLoggingFilter
extends OncePerRequestFilter {
    private final Logger defaultLogger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException e) {
            if (this.shouldLogException(request, response, e)) {
                this.logException(request, response, e);
            }
            throw e;
        }
        catch (ServletException e) {
            if (this.shouldLogException(request, response, e)) {
                this.logException(request, response, e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (this.shouldLogException(request, response, e)) {
                this.logException(request, response, e);
            }
            throw e;
        }
        catch (Error e) {
            if (this.shouldLogException(request, response, e)) {
                this.logException(request, response, e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (this.shouldLogException(request, response, e)) {
                this.logException(request, response, e);
            }
            throw new ServletException(e);
        }
    }

    protected boolean shouldLogException(HttpServletRequest request, HttpServletResponse response, Throwable t) {
        Throwable e = t;
        while (e != null) {
            if (e instanceof SocketException) {
                return false;
            }
            if (e.getClass().getName().equals("org.apache.catalina.connector.ClientAbortException")) {
                return false;
            }
            if (e instanceof ThreadDeath) {
                return false;
            }
            e = e.getCause();
        }
        return true;
    }

    protected void logException(HttpServletRequest request, HttpServletResponse response, Throwable t) {
        this.getLogger(request, response, t).error("exception within servlet", t);
    }

    protected Logger getLogger(HttpServletRequest request, HttpServletResponse response, Throwable t) {
        return this.defaultLogger;
    }
}

