/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.spring;

import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.UncategorizedDataAccessException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;
import org.springframework.transaction.TransactionDefinition;

public class HibernateIsolationJpaDialect
extends HibernateJpaDialect {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public TransactionDataWrapper beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws SQLException {
        if (definition.getTimeout() != -1) {
            this.getSession(entityManager).getTransaction().setTimeout(definition.getTimeout());
        }
        Integer oldIsolation = null;
        Connection connection = null;
        if (definition.getIsolationLevel() != -1) {
            connection = this.getJdbcConnection(entityManager, definition.isReadOnly()).getConnection();
            if (this.log.isTraceEnabled()) {
                this.log.trace("setting isolation level to " + definition.getIsolationLevel() + " on " + connection);
            }
            oldIsolation = DataSourceUtils.prepareConnectionForTransaction((Connection)connection, (TransactionDefinition)definition);
        }
        entityManager.getTransaction().begin();
        return this.prepareTransaction(entityManager, definition, connection, oldIsolation);
    }

    protected TransactionDataWrapper prepareTransaction(EntityManager entityManager, TransactionDefinition definition, Connection connection, Integer oldIsolation) {
        Object transactionData = this.prepareTransaction(entityManager, definition.isReadOnly(), definition.getName());
        return new TransactionDataWrapper(transactionData, connection, oldIsolation);
    }

    public void cleanupTransaction(Object obj) {
        TransactionDataWrapper wrapper = (TransactionDataWrapper)obj;
        super.cleanupTransaction(wrapper.getTransactionData());
        Connection connection = wrapper.getConnection();
        if (connection != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("restoring isolation level to " + wrapper.getIsolation() + " on " + connection);
            }
            DataSourceUtils.resetConnectionAfterTransaction((Connection)connection, (Integer)wrapper.getIsolation(), (boolean)false);
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        Throwable t = ex;
        while (t != null) {
            DataAccessException e;
            if (t instanceof RuntimeException && (e = super.translateExceptionIfPossible(t)) != null && !(e instanceof UncategorizedDataAccessException)) {
                return e;
            }
            t = t.getCause();
        }
        return super.translateExceptionIfPossible(ex);
    }

    protected static class TransactionDataWrapper {
        private final Object transactionData;
        private final Connection connection;
        private final Integer isolation;

        public TransactionDataWrapper(Object transactionData, Connection connection, Integer isolation) {
            this.transactionData = transactionData;
            this.connection = connection;
            this.isolation = isolation;
        }

        public Object getTransactionData() {
            return this.transactionData;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public Integer getIsolation() {
            return this.isolation;
        }
    }
}

