/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.spring;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;

public class ResourceReaderFactoryBean
extends AbstractFactoryBean<String> {
    private Resource resource;
    private String charset = "UTF-8";

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setCharacterEncoding(String charset) {
        this.charset = charset;
    }

    public Class<String> getObjectType() {
        return String.class;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.resource == null) {
            throw new Exception("no resource configured");
        }
    }

    protected String createInstance() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStreamReader reader = new InputStreamReader(this.resource.getInputStream(), this.charset);){
            int r;
            StringWriter writer = new StringWriter();
            char[] buf = new char[4096];
            while ((r = reader.read(buf)) != -1) {
                writer.write(buf, 0, r);
            }
            return writer.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

