/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.spring;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Random;
import org.aspectj.internal.lang.annotation.ajcDeclarePrecedence;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.runtime.internal.AroundClosure;
import org.dellroad.stuff.spring.AbstractBean;
import org.dellroad.stuff.spring.RetryTransaction;
import org.dellroad.stuff.spring.RetryTransactionProvider;
import org.slf4j.Logger;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.TransientDataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Aspect
public class RetryTransactionAspect
extends AbstractBean
implements RetryTransactionProvider {
    private final ThreadLocal<ArrayDeque<RetryInfo>> retryInfos = new ThreadLocal<ArrayDeque<RetryInfo>>(this){
        final /* synthetic */ RetryTransactionAspect this$0;
        {
            this.this$0 = retryTransactionAspect;
        }

        public ArrayDeque<RetryInfo> initialValue() {
            return new ArrayDeque<RetryInfo>(2);
        }
    };
    private final Random random = new Random();
    private int maxRetriesDefault = 4;
    private long initialDelayDefault = 100L;
    private long maximumDelayDefault = 30000L;
    private final AnnotationTransactionAttributeSource transactionAttributeSource = new AnnotationTransactionAttributeSource(false);
    private PersistenceExceptionTranslator persistenceExceptionTranslator;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ RetryTransactionAspect ajc$perSingletonInstance;

    static {
        try {
            RetryTransactionAspect.ajc$perSingletonInstance = new RetryTransactionAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Override
    public PersistenceExceptionTranslator getPersistenceExceptionTranslator() {
        return this.persistenceExceptionTranslator;
    }

    public void setPersistenceExceptionTranslator(PersistenceExceptionTranslator persistenceExceptionTranslator) {
        this.persistenceExceptionTranslator = persistenceExceptionTranslator;
    }

    @Override
    public int getMaxRetriesDefault() {
        return this.maxRetriesDefault;
    }

    public void setMaxRetriesDefault(int maxRetriesDefault) {
        this.maxRetriesDefault = maxRetriesDefault;
    }

    @Override
    public long getInitialDelayDefault() {
        return this.initialDelayDefault;
    }

    public void setInitialDelayDefault(long initialDelayDefault) {
        this.initialDelayDefault = initialDelayDefault;
    }

    @Override
    public long getMaximumDelayDefault() {
        return this.maximumDelayDefault;
    }

    public void setMaximumDelayDefault(long maximumDelayDefault) {
        this.maximumDelayDefault = maximumDelayDefault;
    }

    @Override
    public int getAttemptNumber() {
        return this.getAttemptNumber(null);
    }

    @Override
    public int getAttemptNumber(String transactionManagerName) {
        ArrayDeque<RetryInfo> retryInfoStack = this.retryInfos.get();
        Iterator<RetryInfo> i = retryInfoStack.descendingIterator();
        while (i.hasNext()) {
            RetryInfo retryInfo = i.next();
            if (transactionManagerName != null && !transactionManagerName.equals(retryInfo.getTransactionManagerName())) continue;
            return retryInfo.getAttemptNumber();
        }
        return 0;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.persistenceExceptionTranslator == null) {
            throw new IllegalArgumentException("no PersistenceExceptionTranslator configured");
        }
    }

    @ajcDeclarePrecedence(value="(org.springframework.scheduling.aspectj.*, org.dellroad.stuff.spring.RetryTransactionAspect, org.springframework.transaction.aspectj.*)")
    /* synthetic */ void ajc$declare_precedence_1() {
    }

    @Around(value="retryTransactionalMethodExecution(txObject)", argNames="txObject,ajc$aroundClosure")
    public Object ajc$around$org_dellroad_stuff_spring_RetryTransactionAspect$1$878f3a34(Object txObject, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        MethodSignature methodSignature = (MethodSignature)thisJoinPointStaticPart.getSignature();
        Method method = methodSignature.getMethod();
        TransactionAttribute transactionAttribute = this.transactionAttributeSource.getTransactionAttribute(method, txObject.getClass());
        if (transactionAttribute == null) {
            throw new RuntimeException("no @Transactional annotation found for method " + method + "; required for @RetryTransaction");
        }
        String transactionManagerName = transactionAttribute.getQualifier();
        String description = "@Transactional method " + method;
        switch (transactionAttribute.getPropagationBehavior()) {
            case 3: {
                break;
            }
            case 0: {
                if (!TransactionSynchronizationManager.isActualTransactionActive() || this.getAttemptNumber(transactionManagerName) <= 0) break;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("skipping retry logic; transaction already open for {} in {}", (Object)transactionManagerName, (Object)description);
                }
                return ajc$aroundClosure.run(new Object[]{txObject});
            }
            default: {
                return ajc$aroundClosure.run(new Object[]{txObject});
            }
        }
        RetryTransaction retryTransaction = (RetryTransaction)AnnotationUtils.getAnnotation((Method)method, RetryTransaction.class);
        if (retryTransaction == null) {
            retryTransaction = (RetryTransaction)AnnotationUtils.findAnnotation(method.getDeclaringClass(), RetryTransaction.class);
        }
        return this.retry(new RetryTransactionProvider.RetrySetup<Object>(transactionManagerName, description, () -> ajc$aroundClosure.run(new Object[]{txObject}), retryTransaction));
    }

    @Override
    public <T> T retry(RetryTransactionProvider.RetrySetup<T> setup) {
        long maximumDelay;
        if (setup == null) {
            throw new IllegalArgumentException("null setup");
        }
        int maxRetries = setup.getMaxRetries() != -1 ? setup.getMaxRetries() : this.maxRetriesDefault;
        long initialDelay = setup.getInitialDelay() != -1L ? setup.getInitialDelay() : this.initialDelayDefault;
        long l = maximumDelay = setup.getMaximumDelay() != -1L ? setup.getMaximumDelay() : this.maximumDelayDefault;
        if (this.persistenceExceptionTranslator == null) {
            throw new RuntimeException("@RetryTransaction aspect must be configured with a " + PersistenceExceptionTranslator.class.getSimpleName() + " before use");
        }
        RetryInfo retryInfo = new RetryInfo(setup.getTransactionManagerName());
        while (true) {
            int attempt = retryInfo.getAttemptNumber();
            if (retryInfo.getAttemptNumber() > 1) {
                long delay = this.calculateDelay(attempt, initialDelay, maximumDelay);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("pausing {}ms before retrying {}", (Object)delay, (Object)setup.getDescription());
                }
                this.pause(delay);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("retrying {} (attempt #{})", (Object)setup.getDescription(), (Object)attempt);
                }
            }
            try {
                T result;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("starting {} (attempt #{})", (Object)setup.getDescription(), (Object)attempt);
                }
                this.retryInfos.get().push(retryInfo);
                try {
                    result = setup.getTransaction().get();
                }
                finally {
                    this.retryInfos.get().pop();
                }
                if (attempt > 1) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("successfully completed {} on re-try attempt #{}", (Object)setup.getDescription(), (Object)attempt);
                    }
                } else if (this.log.isTraceEnabled()) {
                    this.log.trace("successfully completed {} on first attempt", (Object)setup.getDescription());
                }
                return result;
            }
            catch (RuntimeException e) {
                DataAccessException translatedException = e instanceof DataAccessException && e.getCause() instanceof RuntimeException ? this.persistenceExceptionTranslator.translateExceptionIfPossible((RuntimeException)e.getCause()) : (e instanceof DataAccessException ? (DataAccessException)e : this.persistenceExceptionTranslator.translateExceptionIfPossible(e));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("exception from {} on attempt #{}: {}{}", new Object[]{setup.getDescription(), attempt, e.toString(), translatedException != null ? " (translates to " + translatedException.getClass().getSimpleName() + ")" : ""});
                }
                if (!(translatedException instanceof TransientDataAccessException)) {
                    throw e;
                }
                TransientDataAccessException transientException = (TransientDataAccessException)translatedException;
                if (retryInfo.incrementAttemptNumber() <= maxRetries) continue;
                this.log.error("{} failed after {} attempts, giving up!", (Object)setup.getDescription(), (Object)maxRetries);
                throw transientException;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long calculateDelay(int attempt, long initialDelay, long maximumDelay) {
        initialDelay = Math.max(initialDelay, 1L);
        maximumDelay = Math.max(maximumDelay, 1L);
        long delay = initialDelay = Math.min(initialDelay, maximumDelay);
        while (attempt-- > 1) {
            if ((delay <<= 1) < maximumDelay) continue;
            delay = maximumDelay;
            break;
        }
        int randomRange = Math.max(1, (int)(delay >> 2));
        Random random = this.random;
        synchronized (random) {
            delay += (long)(this.random.nextInt(randomRange) - randomRange / 2);
        }
        delay = Math.min(delay, maximumDelay);
        return delay;
    }

    protected void pause(long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Pointcut(value="(execution(public * (@org.springframework.transaction.annotation.Transactional *).*(..)) || execution(public * (@((@org.springframework.transaction.annotation.Transactional *)) *).*(..)))", argNames="")
    private /* synthetic */ void ajc$pointcut$$executionOfPublicMethodInTransactionalType$34ac() {
    }

    @Pointcut(value="(execution(public * (@org.dellroad.stuff.spring.RetryTransaction *).*(..)) || execution(public * (@((@org.dellroad.stuff.spring.RetryTransaction *)) *).*(..)))", argNames="")
    private /* synthetic */ void ajc$pointcut$$executionOfPublicMethodInRetryTransactionType$3621() {
    }

    @Pointcut(value="(execution(@org.springframework.transaction.annotation.Transactional * *(..)) || execution(@((@org.springframework.transaction.annotation.Transactional *)) * *(..)))", argNames="")
    private /* synthetic */ void ajc$pointcut$$executionOfTransactionalMethod$3743() {
    }

    @Pointcut(value="(execution(@org.dellroad.stuff.spring.RetryTransaction * *(..)) || execution(@((@org.dellroad.stuff.spring.RetryTransaction *)) * *(..)))", argNames="")
    private /* synthetic */ void ajc$pointcut$$executionOfRetryTransactionMethod$3837() {
    }

    @Pointcut(value="(this(txObject) && ((executionOfPublicMethodInTransactionalType() || executionOfTransactionalMethod()) && (executionOfPublicMethodInRetryTransactionType() || executionOfRetryTransactionMethod())))", argNames="txObject")
    private /* synthetic */ void ajc$pointcut$$retryTransactionalMethodExecution$394b(Object object) {
    }

    public static RetryTransactionAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org_dellroad_stuff_spring_RetryTransactionAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_dellroad_stuff_spring_RetryTransactionAspect$org_dellroad_stuff_spring_RetryTransactionAspect$transactionAttributeSource(RetryTransactionAspect retryTransactionAspect, AnnotationTransactionAttributeSource annotationTransactionAttributeSource) {
        retryTransactionAspect.transactionAttributeSource = annotationTransactionAttributeSource;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_dellroad_stuff_spring_RetryTransactionAspect$org_dellroad_stuff_spring_RetryTransactionAspect$log(RetryTransactionAspect retryTransactionAspect, Logger logger) {
        retryTransactionAspect.log = logger;
    }

    private static class RetryInfo {
        private final String transactionManagerName;
        private int attemptNumber = 1;

        RetryInfo(String transactionManagerName) {
            this.transactionManagerName = transactionManagerName;
        }

        public String getTransactionManagerName() {
            return this.transactionManagerName;
        }

        public int getAttemptNumber() {
            return this.attemptNumber;
        }

        public int incrementAttemptNumber() {
            return this.attemptNumber++;
        }
    }
}

