/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.spring;

import java.util.function.Supplier;
import org.dellroad.stuff.spring.RetryTransaction;
import org.springframework.dao.support.PersistenceExceptionTranslator;

public interface RetryTransactionProvider {
    public PersistenceExceptionTranslator getPersistenceExceptionTranslator();

    public int getMaxRetriesDefault();

    public long getInitialDelayDefault();

    public long getMaximumDelayDefault();

    public int getAttemptNumber();

    public int getAttemptNumber(String var1);

    public <T> T retry(RetrySetup<T> var1);

    public static class RetrySetup<T> {
        private final String transactionManagerName;
        private final String description;
        private final Supplier<T> transaction;
        private final int maxRetries;
        private final long initialDelay;
        private final long maximumDelay;

        public RetrySetup(String transactionManagerName, String description, Supplier<T> transaction) {
            this(transactionManagerName, description, transaction, -1, -1L, -1L);
        }

        public RetrySetup(String transactionManagerName, String description, Supplier<T> transaction, RetryTransaction annotation) {
            this(transactionManagerName, description, transaction, annotation != null ? annotation.maxRetries() : -1, annotation != null ? annotation.initialDelay() : -1L, annotation != null ? annotation.maximumDelay() : -1L);
        }

        public RetrySetup(String transactionManagerName, String description, Supplier<T> transaction, int maxRetries, long initialDelay, long maximumDelay) {
            if (description == null) {
                throw new IllegalArgumentException("null description");
            }
            if (transaction == null) {
                throw new IllegalArgumentException("null transaction");
            }
            this.transactionManagerName = transactionManagerName;
            this.description = description;
            this.transaction = transaction;
            this.maxRetries = maxRetries;
            this.initialDelay = initialDelay;
            this.maximumDelay = maximumDelay;
        }

        public String getTransactionManagerName() {
            return this.transactionManagerName;
        }

        public String getDescription() {
            return this.description;
        }

        public Supplier<T> getTransaction() {
            return this.transaction;
        }

        public int getMaxRetries() {
            return this.maxRetries;
        }

        public long getInitialDelay() {
            return this.initialDelay;
        }

        public long getMaximumDelay() {
            return this.maximumDelay;
        }
    }
}

