/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;

public abstract class TestSupport {
    private static boolean reportedSeed;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Validator validator;
    protected Random random;

    @BeforeClass
    public void setUpValidator() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        this.validator = factory.getValidator();
    }

    @BeforeClass
    @Parameters(value={"randomSeed"})
    public void seedRandom(String randomSeed) {
        this.random = TestSupport.getRandom(randomSeed);
    }

    public static Random getRandom(String randomSeed) {
        long seed;
        try {
            seed = Long.parseLong(randomSeed);
        }
        catch (NumberFormatException e) {
            seed = System.currentTimeMillis();
        }
        if (!reportedSeed) {
            reportedSeed = true;
            LoggerFactory.getLogger(TestSupport.class).info("test seed = " + seed);
        }
        return new Random(seed);
    }

    protected <T> Set<ConstraintViolation<T>> checkValid(T object, boolean valid) {
        Set violations = this.validator.validate(object, new Class[0]);
        if (valid) {
            for (ConstraintViolation violation : violations) {
                this.log.error("unexpected validation error: [" + violation.getPropertyPath() + "]: " + violation.getMessage());
            }
            Assert.assertTrue((boolean)violations.isEmpty(), (String)("found constraint violations: " + violations));
        } else {
            Assert.assertFalse((boolean)violations.isEmpty(), (String)"expected constraint violations but none were found");
        }
        return violations;
    }

    protected String readResource(File file) {
        try {
            return this.readResource(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("can't URL'ify file: " + file);
        }
    }

    protected String readResource(String path) {
        URL url = this.getClass().getResource(path);
        if (url == null) {
            throw new RuntimeException("can't find resource `" + path + "'");
        }
        return this.readResource(url);
    }

    protected String readResource(URL url) {
        String string;
        InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
        try {
            int r;
            StringWriter writer = new StringWriter();
            char[] buf = new char[1024];
            while ((r = reader.read(buf)) != -1) {
                writer.write(buf, 0, r);
            }
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("error reading from " + url, e);
            }
        }
        reader.close();
        return string;
    }
}

