/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.test.action;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.deltafi.actionkit.action.DataAmendedResult;
import org.deltafi.actionkit.action.Result;
import org.deltafi.actionkit.action.ResultType;
import org.deltafi.actionkit.action.error.ErrorResult;
import org.deltafi.actionkit.action.filter.FilterResult;
import org.deltafi.actionkit.properties.ActionsProperties;
import org.deltafi.common.content.ContentReference;
import org.deltafi.common.content.ContentStorageService;
import org.deltafi.common.content.Segment;
import org.deltafi.common.storage.s3.ObjectStorageException;
import org.deltafi.common.types.ActionContext;
import org.deltafi.common.types.Content;
import org.deltafi.common.types.DeltaFile;
import org.deltafi.common.types.FormattedData;
import org.deltafi.common.types.KeyValue;
import org.deltafi.common.types.ProtocolLayer;
import org.deltafi.common.types.SourceInfo;
import org.deltafi.test.action.IOContent;
import org.deltafi.test.action.TestCaseBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={MockitoExtension.class})
public abstract class ActionTest {
    private static final Logger log = LoggerFactory.getLogger(ActionTest.class);
    private static final Map<String, Pattern> NORMALIZED_REPLACEMENTS_MAP = Map.of("stop=stopDateTime", Pattern.compile("stop=\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(-\\d{2}:\\d{2})?"), "Segment(uuid=00000000-0000-0000-0000-000000000001", Pattern.compile("Segment\\(uuid=[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"));
    protected final String DID = "did";
    protected final String HOSTNAME = "hostname";
    @Mock
    protected ActionsProperties actionsProperties;
    @Mock
    protected ContentStorageService contentStorageService;

    protected String convertUTCDateToLocal(String utcDateString) {
        DateTimeFormatter javaStdDateToStringFormatter = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
        ZonedDateTime utcDate = ZonedDateTime.parse(utcDateString, javaStdDateToStringFormatter);
        return utcDate.toOffsetDateTime().atZoneSameInstant(ZoneId.systemDefault()).format(javaStdDateToStringFormatter);
    }

    private void setMocksForLoad(TestCaseBase<?> testCase, ContentReference reference, byte[] content) {
        if (testCase.getExceptionLocation() == TestCaseBase.ExceptionLocation.STORAGE_READ) {
            Mockito.lenient().when((Object)this.contentStorageService.load((ContentReference)Mockito.eq((Object)reference))).thenThrow(new Throwable[]{testCase.getException()});
        } else {
            Mockito.lenient().when((Object)this.contentStorageService.load((ContentReference)Mockito.eq((Object)reference))).thenReturn((Object)new ByteArrayInputStream(content));
        }
    }

    protected List<Content> getContents(List<? extends IOContent> contents, TestCaseBase<?> testCase, String stripIfStartsWith) {
        return contents.stream().map(ioContent -> {
            try {
                byte[] content = this.getTestResourceOrDefault(testCase.getTestName(), ioContent.getName(), () -> new ByteArrayInputStream(ioContent.getName().getBytes(StandardCharsets.UTF_8))).readAllBytes();
                Segment segment = new Segment(UUID.randomUUID().toString(), 0L, (long)content.length, "did");
                ContentReference reference = new ContentReference(ioContent.getContentType(), new Segment[]{segment});
                this.setMocksForLoad(testCase, reference, content);
                return Content.newBuilder().name(ioContent.getName().startsWith(stripIfStartsWith) ? ioContent.getName().substring(stripIfStartsWith.length()) : ioContent.getName()).contentReference(reference).metadata(ioContent.getMetadata()).build();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList());
    }

    protected List<Content> createContents(TestCaseBase<?> testCase, List<? extends IOContent> outputs) {
        return outputs.stream().map(this.convertOutputToContent(testCase)).collect(Collectors.toList());
    }

    protected Function<IOContent, Content> convertOutputToContent(TestCaseBase<?> testCase) {
        return output -> {
            try {
                byte[] content = this.getTestResourceOrEmpty(testCase.getTestName(), output.getName()).readAllBytes();
                Segment segment = new Segment(UUID.randomUUID().toString(), 0L, (long)content.length, "did");
                ContentReference reference = new ContentReference(output.getContentType(), new Segment[]{segment});
                this.setMocksForLoad(testCase, reference, content);
                return Content.newBuilder().name(output.getName().startsWith("output.") ? output.getName().substring(7) : output.getName()).metadata(output.getMetadata()).contentReference(reference).build();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        };
    }

    protected InputStream getTestResourceOrDefault(String testCaseName, String file, Supplier<InputStream> supplier) {
        InputStream inputStream;
        block8: {
            InputStream ret = this.getClass().getClassLoader().getResourceAsStream(this.getClass().getSimpleName() + "/" + testCaseName + "/" + file);
            try {
                InputStream inputStream2 = inputStream = ret == null ? supplier.get() : new ByteArrayInputStream(ret.readAllBytes());
                if (ret == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ret != null) {
                        try {
                            ret.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return supplier.get();
                }
            }
            ret.close();
        }
        return inputStream;
    }

    protected DeltaFile deltaFile(Map<String, String> metadata, List<Content> content) {
        return DeltaFile.newBuilder().sourceInfo(SourceInfo.builder().metadata(metadata == null ? new ArrayList() : metadata.entrySet().stream().map(kv -> new KeyValue((String)kv.getKey(), (String)kv.getValue())).collect(Collectors.toList())).filename("filename").flow("flow").build()).protocolStack(Collections.singletonList(ProtocolLayer.builder().metadata(Collections.emptyList()).action("action").content(content).build())).formattedData(content.stream().map(Content::getContentReference).map(cr -> FormattedData.newBuilder().contentReference(cr).build()).collect(Collectors.toList())).did("did").build();
    }

    protected ActionContext context() {
        return ActionContext.builder().did("did").name("name").ingressFlow(null).egressFlow(null).hostname("hostname").systemName("systemName").actionVersion("1.0").startTime(OffsetDateTime.of(2000, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC)).build();
    }

    protected void beforeExecuteAction(DeltaFile deltaFile, TestCaseBase<?> testCase) {
    }

    protected ResultType callAction(TestCaseBase<?> testCase) {
        List<Content> inputs = this.getContents(testCase.getInputs(), testCase, "input.");
        DeltaFile deltaFile = this.deltaFile(testCase.getSourceMetadata(), inputs);
        Mockito.lenient().when((Object)this.actionsProperties.getHostname()).thenReturn((Object)"hostname");
        this.beforeExecuteAction(deltaFile, testCase);
        return testCase.getAction().executeAction(deltaFile, this.context(), testCase.getParameters());
    }

    protected List<Content> createContentReferencesForSaveMany(InvocationOnMock invocation) throws ObjectStorageException, IOException {
        String did = (String)invocation.getArgument(0);
        Map contentToBytes = (Map)invocation.getArgument(1);
        ArrayList<Content> contentList = new ArrayList<Content>();
        for (Map.Entry contentToByte : contentToBytes.entrySet()) {
            Content content = (Content)contentToByte.getKey();
            byte[] bytes = (byte[])contentToByte.getValue();
            content.setContentReference(this.createContentReference(did, "application/octet-stream", bytes));
            contentList.add(content);
        }
        return contentList;
    }

    protected ContentReference createContentReference(InvocationOnMock invocation) throws IOException, ObjectStorageException {
        String did = (String)invocation.getArgument(0);
        String contentType = (String)invocation.getArgument(2);
        Object bytesOrStream = invocation.getArgument(1);
        return this.createContentReference(did, contentType, bytesOrStream);
    }

    protected ContentReference createContentReference(String did, String contentType, Object bytesOrStream) throws IOException, ObjectStorageException {
        byte[] bytes = bytesOrStream instanceof InputStream ? ((InputStream)bytesOrStream).readAllBytes() : (byte[])bytesOrStream;
        Segment segment = new Segment(UUID.randomUUID().toString(), 0L, (long)bytes.length, did);
        ContentReference reference = new ContentReference(contentType, new Segment[]{segment});
        Mockito.lenient().when((Object)this.contentStorageService.load((ContentReference)Mockito.eq((Object)reference))).thenReturn((Object)new ByteArrayInputStream(bytes));
        return reference;
    }

    public void executeFilter(TestCaseBase<?> testCase) {
        FilterResult result = this.execute(testCase, FilterResult.class);
        if (!testCase.getRegex().matcher(result.getFilteredCause()).find()) {
            Assertions.fail((String)("FilterResult message does not match expected regex: expected(" + testCase.getRegex().pattern() + ") actual(" + result.getFilteredCause() + ")"));
        }
    }

    public void executeError(TestCaseBase<?> testCase) {
        ErrorResult result = this.execute(testCase, ErrorResult.class);
        if (!testCase.getRegex().matcher(result.toEvent().getError().getCause()).find()) {
            Assertions.fail((String)("ErrorResult does not match expected regex: expected(" + testCase.getRegex().pattern() + ") actual(" + result.toEvent().getError().getCause() + ")"));
        }
    }

    public void execute(TestCaseBase<?> testCase) {
        if (testCase.getExpectedResultType() == ErrorResult.class) {
            this.executeError(testCase);
        } else if (testCase.getExpectedResultType() == FilterResult.class) {
            this.executeFilter(testCase);
        } else {
            Assertions.fail((String)("Did not expect result type of " + testCase.getExpectedResultType()));
        }
    }

    public <TC extends TestCaseBase<?>, RT extends Result> RT execute(TC testCase, Class<RT> expectedResultType) {
        if (testCase.getExceptionLocation() == TestCaseBase.ExceptionLocation.STORAGE_WRITE) {
            Mockito.lenient().when((Object)this.contentStorageService.save(Mockito.anyString(), (byte[])Mockito.any(byte[].class), Mockito.anyString())).thenThrow(new Throwable[]{testCase.getException()});
            Mockito.lenient().when((Object)this.contentStorageService.save(Mockito.anyString(), (InputStream)Mockito.any(InputStream.class), Mockito.anyString())).thenThrow(new Throwable[]{testCase.getException()});
            Mockito.lenient().when((Object)this.contentStorageService.saveMany(Mockito.anyString(), Mockito.anyMap())).thenThrow(new Throwable[]{testCase.getException()});
        } else {
            Mockito.lenient().when((Object)this.contentStorageService.save(Mockito.anyString(), (byte[])Mockito.any(byte[].class), Mockito.anyString())).thenAnswer(this::createContentReference);
            Mockito.lenient().when((Object)this.contentStorageService.save(Mockito.anyString(), (InputStream)Mockito.any(InputStream.class), Mockito.anyString())).thenAnswer(this::createContentReference);
            Mockito.lenient().when((Object)this.contentStorageService.saveMany(Mockito.anyString(), Mockito.anyMap())).thenAnswer(this::createContentReferencesForSaveMany);
        }
        ResultType result = this.callAction(testCase);
        if (!expectedResultType.isInstance(result)) {
            Assertions.fail((String)(result.getClass().getSimpleName() + " returned when not expected"));
        }
        return (RT)((Result)expectedResultType.cast(result));
    }

    protected String normalizeData(String input) {
        return NORMALIZED_REPLACEMENTS_MAP.entrySet().stream().reduce(input, this::applyPattern, (u1, u2) -> u2);
    }

    private String applyPattern(String input, Map.Entry<String, Pattern> entry) {
        return entry.getValue().matcher(input).replaceAll(entry.getKey());
    }

    protected InputStream getTestResourceOrEmpty(String testCaseName, String file) {
        return this.getTestResourceOrDefault(testCaseName, file, () -> new ByteArrayInputStream(new byte[0]));
    }

    protected <R> List<R> orderListByAnother(List<R> orderBy, List<R> toOrder, Function<R, ?> getIdProperty) {
        return orderBy.stream().map(getIdProperty).map(itemValue -> this.getObjectByLambda(toOrder, item -> getIdProperty.apply(item).equals(itemValue), () -> Assertions.fail((String)"Unable to find correct item in list to normalize"))).collect(Collectors.toList());
    }

    protected <R> R getObjectByLambda(List<R> list, Predicate<R> isCorrectOne, Supplier<R> ifNotFound) {
        return (R)list.stream().filter(isCorrectOne).findFirst().orElseGet(ifNotFound);
    }

    protected List<byte[]> getExpectedContentOutputNormalized(DataAmendedResult expectedResult, DataAmendedResult actualResult, TestCaseBase<?> testCase, List<? extends IOContent> outputs) {
        List<Content> expectedContent = this.createContents(testCase, outputs);
        List<Content> normalizedExpectedContent = this.orderListByAnother(actualResult.getContent(), expectedContent, Content::getName);
        expectedResult.setContent(normalizedExpectedContent);
        return normalizedExpectedContent.stream().map(this::getContent).collect(Collectors.toList());
    }

    protected byte[] getContent(Content content) {
        byte[] byArray;
        block8: {
            InputStream stream = this.contentStorageService.load(content.getContentReference());
            try {
                byArray = stream.readAllBytes();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return null;
                }
            }
            stream.close();
        }
        return byArray;
    }

    protected void assertContentIsEqual(List<byte[]> expected, List<byte[]> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size(), (String)"Expected content list size does not match actual content list size");
        for (int ii = 0; ii < expected.size(); ++ii) {
            Assertions.assertEquals((int)0, (int)Arrays.compare(expected.get(ii), actual.get(ii)), (String)("Content at index " + ii + " does not match expected content"));
        }
    }
}

