/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.test.action;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.deltafi.actionkit.action.Action;
import org.deltafi.actionkit.action.Result;
import org.deltafi.actionkit.action.error.ErrorResult;
import org.deltafi.actionkit.action.filter.FilterResult;
import org.deltafi.actionkit.action.parameters.ActionParameters;
import org.deltafi.test.action.IOContent;

public class TestCaseBase<A extends Action<? extends ActionParameters>> {
    private Class<? extends Result> expectedResultType;
    public A action;
    public Map<String, Object> parameters;
    public String testName;
    private List<IOContent> inputs;
    private Map<String, String> sourceMetadata;
    private List<? extends IOContent> outputs;
    private Map<String, String> resultMetadata;
    private Pattern regex;
    private Throwable exception;
    private ExceptionLocation exceptionLocation;

    private static <A extends Action<? extends ActionParameters>> List<IOContent> $default$inputs() {
        return Collections.emptyList();
    }

    private static <A extends Action<? extends ActionParameters>> List<? extends IOContent> $default$outputs() {
        return Collections.emptyList();
    }

    private static <A extends Action<? extends ActionParameters>> Map<String, String> $default$resultMetadata() {
        return Collections.emptyMap();
    }

    private static <A extends Action<? extends ActionParameters>> Throwable $default$exception() {
        return null;
    }

    private static <A extends Action<? extends ActionParameters>> ExceptionLocation $default$exceptionLocation() {
        return ExceptionLocation.NONE;
    }

    protected TestCaseBase(TestCaseBaseBuilder<A, ?, ?> b) {
        this.expectedResultType = b.expectedResultType;
        this.action = b.action;
        this.parameters = b.parameters;
        this.testName = b.testName;
        this.inputs = b.inputs$set ? b.inputs$value : TestCaseBase.$default$inputs();
        this.sourceMetadata = b.sourceMetadata;
        this.outputs = b.outputs$set ? b.outputs$value : TestCaseBase.$default$outputs();
        this.resultMetadata = b.resultMetadata$set ? b.resultMetadata$value : TestCaseBase.$default$resultMetadata();
        this.regex = b.regex;
        this.exception = b.exception$set ? b.exception$value : TestCaseBase.$default$exception();
        this.exceptionLocation = b.exceptionLocation$set ? b.exceptionLocation$value : TestCaseBase.$default$exceptionLocation();
    }

    public static <A extends Action<? extends ActionParameters>> TestCaseBaseBuilder<A, ?, ?> builder() {
        return new TestCaseBaseBuilderImpl();
    }

    public Class<? extends Result> getExpectedResultType() {
        return this.expectedResultType;
    }

    public A getAction() {
        return this.action;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getTestName() {
        return this.testName;
    }

    public List<IOContent> getInputs() {
        return this.inputs;
    }

    public Map<String, String> getSourceMetadata() {
        return this.sourceMetadata;
    }

    public List<? extends IOContent> getOutputs() {
        return this.outputs;
    }

    public Map<String, String> getResultMetadata() {
        return this.resultMetadata;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public Throwable getException() {
        return this.exception;
    }

    public ExceptionLocation getExceptionLocation() {
        return this.exceptionLocation;
    }

    public void setExpectedResultType(Class<? extends Result> expectedResultType) {
        this.expectedResultType = expectedResultType;
    }

    public void setAction(A action) {
        this.action = action;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public void setInputs(List<IOContent> inputs) {
        this.inputs = inputs;
    }

    public void setSourceMetadata(Map<String, String> sourceMetadata) {
        this.sourceMetadata = sourceMetadata;
    }

    public void setOutputs(List<? extends IOContent> outputs) {
        this.outputs = outputs;
    }

    public void setResultMetadata(Map<String, String> resultMetadata) {
        this.resultMetadata = resultMetadata;
    }

    public void setRegex(Pattern regex) {
        this.regex = regex;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public void setExceptionLocation(ExceptionLocation exceptionLocation) {
        this.exceptionLocation = exceptionLocation;
    }

    public String toString() {
        return "TestCaseBase(expectedResultType=" + this.getExpectedResultType() + ", action=" + this.getAction() + ", parameters=" + this.getParameters() + ", testName=" + this.getTestName() + ", inputs=" + this.getInputs() + ", sourceMetadata=" + this.getSourceMetadata() + ", outputs=" + this.getOutputs() + ", resultMetadata=" + this.getResultMetadata() + ", regex=" + this.getRegex() + ", exception=" + this.getException() + ", exceptionLocation=" + this.getExceptionLocation() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestCaseBase)) {
            return false;
        }
        TestCaseBase other = (TestCaseBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<Result> this$expectedResultType = this.getExpectedResultType();
        Class<Result> other$expectedResultType = other.getExpectedResultType();
        if (this$expectedResultType == null ? other$expectedResultType != null : !this$expectedResultType.equals(other$expectedResultType)) {
            return false;
        }
        A this$action = this.getAction();
        A other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        Map<String, Object> this$parameters = this.getParameters();
        Map<String, Object> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$testName = this.getTestName();
        String other$testName = other.getTestName();
        if (this$testName == null ? other$testName != null : !this$testName.equals(other$testName)) {
            return false;
        }
        List<IOContent> this$inputs = this.getInputs();
        List<IOContent> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Map<String, String> this$sourceMetadata = this.getSourceMetadata();
        Map<String, String> other$sourceMetadata = other.getSourceMetadata();
        if (this$sourceMetadata == null ? other$sourceMetadata != null : !((Object)this$sourceMetadata).equals(other$sourceMetadata)) {
            return false;
        }
        List<IOContent> this$outputs = this.getOutputs();
        List<IOContent> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        Map<String, String> this$resultMetadata = this.getResultMetadata();
        Map<String, String> other$resultMetadata = other.getResultMetadata();
        if (this$resultMetadata == null ? other$resultMetadata != null : !((Object)this$resultMetadata).equals(other$resultMetadata)) {
            return false;
        }
        Pattern this$regex = this.getRegex();
        Pattern other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !this$regex.equals(other$regex)) {
            return false;
        }
        Throwable this$exception = this.getException();
        Throwable other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        ExceptionLocation this$exceptionLocation = this.getExceptionLocation();
        ExceptionLocation other$exceptionLocation = other.getExceptionLocation();
        return !(this$exceptionLocation == null ? other$exceptionLocation != null : !((Object)((Object)this$exceptionLocation)).equals((Object)other$exceptionLocation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestCaseBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<Result> $expectedResultType = this.getExpectedResultType();
        result = result * 59 + ($expectedResultType == null ? 43 : $expectedResultType.hashCode());
        A $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        Map<String, Object> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $testName = this.getTestName();
        result = result * 59 + ($testName == null ? 43 : $testName.hashCode());
        List<IOContent> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Map<String, String> $sourceMetadata = this.getSourceMetadata();
        result = result * 59 + ($sourceMetadata == null ? 43 : ((Object)$sourceMetadata).hashCode());
        List<IOContent> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        Map<String, String> $resultMetadata = this.getResultMetadata();
        result = result * 59 + ($resultMetadata == null ? 43 : ((Object)$resultMetadata).hashCode());
        Pattern $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
        Throwable $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        ExceptionLocation $exceptionLocation = this.getExceptionLocation();
        result = result * 59 + ($exceptionLocation == null ? 43 : ((Object)((Object)$exceptionLocation)).hashCode());
        return result;
    }

    private static final class TestCaseBaseBuilderImpl<A extends Action<? extends ActionParameters>>
    extends TestCaseBaseBuilder<A, TestCaseBase<A>, TestCaseBaseBuilderImpl<A>> {
        private TestCaseBaseBuilderImpl() {
        }

        @Override
        protected TestCaseBaseBuilderImpl<A> self() {
            return this;
        }

        @Override
        public TestCaseBase<A> build() {
            return new TestCaseBase(this);
        }
    }

    public static abstract class TestCaseBaseBuilder<A extends Action<? extends ActionParameters>, C extends TestCaseBase<A>, B extends TestCaseBaseBuilder<A, C, B>> {
        private Class<? extends Result> expectedResultType;
        private A action;
        private Map<String, Object> parameters;
        private String testName;
        private boolean inputs$set;
        private List<IOContent> inputs$value;
        private Map<String, String> sourceMetadata;
        private boolean outputs$set;
        private List<? extends IOContent> outputs$value;
        private boolean resultMetadata$set;
        private Map<String, String> resultMetadata$value;
        private Pattern regex;
        private boolean exception$set;
        private Throwable exception$value;
        private boolean exceptionLocation$set;
        private ExceptionLocation exceptionLocation$value;

        public B throwStorageReadException(Throwable exception) {
            this.exception(exception);
            this.exceptionLocation(ExceptionLocation.STORAGE_READ);
            return this.self();
        }

        public B throwStorageWriteException(Throwable exception) {
            this.exception(exception);
            this.exceptionLocation(ExceptionLocation.STORAGE_WRITE);
            return this.self();
        }

        public B expectError(String errorRegex) {
            return this.expectError(Pattern.compile(errorRegex));
        }

        public B expectError(Pattern errorRegex) {
            this.expectedResultType(ErrorResult.class);
            this.regex(errorRegex);
            return this.self();
        }

        public B expectFilter(String filterRegex) {
            return this.expectFilter(Pattern.compile(filterRegex));
        }

        public B expectFilter(Pattern filterRegex) {
            this.expectedResultType(FilterResult.class);
            this.regex(filterRegex);
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public B expectedResultType(Class<? extends Result> expectedResultType) {
            this.expectedResultType = expectedResultType;
            return this.self();
        }

        public B action(A action) {
            this.action = action;
            return this.self();
        }

        public B parameters(Map<String, Object> parameters) {
            this.parameters = parameters;
            return this.self();
        }

        public B testName(String testName) {
            this.testName = testName;
            return this.self();
        }

        public B inputs(List<IOContent> inputs) {
            this.inputs$value = inputs;
            this.inputs$set = true;
            return this.self();
        }

        public B sourceMetadata(Map<String, String> sourceMetadata) {
            this.sourceMetadata = sourceMetadata;
            return this.self();
        }

        public B outputs(List<? extends IOContent> outputs) {
            this.outputs$value = outputs;
            this.outputs$set = true;
            return this.self();
        }

        public B resultMetadata(Map<String, String> resultMetadata) {
            this.resultMetadata$value = resultMetadata;
            this.resultMetadata$set = true;
            return this.self();
        }

        public B regex(Pattern regex) {
            this.regex = regex;
            return this.self();
        }

        public B exception(Throwable exception) {
            this.exception$value = exception;
            this.exception$set = true;
            return this.self();
        }

        public B exceptionLocation(ExceptionLocation exceptionLocation) {
            this.exceptionLocation$value = exceptionLocation;
            this.exceptionLocation$set = true;
            return this.self();
        }

        public String toString() {
            return "TestCaseBase.TestCaseBaseBuilder(expectedResultType=" + this.expectedResultType + ", action=" + this.action + ", parameters=" + this.parameters + ", testName=" + this.testName + ", inputs$value=" + this.inputs$value + ", sourceMetadata=" + this.sourceMetadata + ", outputs$value=" + this.outputs$value + ", resultMetadata$value=" + this.resultMetadata$value + ", regex=" + this.regex + ", exception$value=" + this.exception$value + ", exceptionLocation$value=" + this.exceptionLocation$value + ")";
        }
    }

    public static enum ExceptionLocation {
        NONE,
        STORAGE_READ,
        STORAGE_WRITE;

    }
}

