/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.test.action.format;

import java.io.InputStream;
import java.util.stream.Collectors;
import org.deltafi.actionkit.action.format.FormatResult;
import org.deltafi.common.content.ContentReference;
import org.deltafi.common.types.DeltaFile;
import org.deltafi.test.action.ActionTest;
import org.deltafi.test.action.Enrichment;
import org.deltafi.test.action.IOContent;
import org.deltafi.test.action.TestCaseBase;
import org.deltafi.test.action.format.FormatActionTestCase;
import org.junit.jupiter.api.Assertions;

public class FormatActionTest
extends ActionTest {
    public void execute(FormatActionTestCase testCase) {
        if (testCase.getExpectedResultType() == FormatResult.class) {
            FormatResult result = this.execute(testCase, FormatResult.class);
            this.assertFormatResult(testCase, result);
        } else {
            super.execute(testCase);
        }
    }

    @Override
    protected void beforeExecuteAction(DeltaFile deltaFile, TestCaseBase<?> testCase) {
        FormatActionTestCase formatActionTestCase = (FormatActionTestCase)testCase;
        deltaFile.setEnrichment(formatActionTestCase.getEnrichments().stream().map(this::readEnrichment).collect(Collectors.toList()));
    }

    private org.deltafi.common.types.Enrichment readEnrichment(Enrichment enrichment) {
        return org.deltafi.common.types.Enrichment.newBuilder().value(enrichment.getValue()).name(enrichment.getName()).mediaType(enrichment.getContentType()).build();
    }

    public void assertFormatResult(FormatActionTestCase testCase, FormatResult result) {
        IOContent formatOutput = testCase.getOutputs().get(0);
        Assertions.assertEquals(formatOutput.getMetadata(), (Object)result.getMetadata());
        Assertions.assertEquals((Object)formatOutput.getContentType(), (Object)result.getContentReference().getMediaType());
        Assertions.assertEquals((Object)formatOutput.getName(), (Object)result.getFilename());
        byte[] actualContent = null;
        try (InputStream actualContentInputstream = this.contentStorageService.load(result.getContentReference());){
            actualContent = actualContentInputstream.readAllBytes();
        }
        catch (Throwable t) {
            Assertions.fail((String)"Unable to read content for actual comparisons", (Throwable)t);
        }
        ContentReference expectedReference = this.getContents(testCase.getOutputs(), testCase, "output.").get(0).getContentReference();
        byte[] expectedContent = null;
        try (InputStream expectedContentInputstream = this.contentStorageService.load(expectedReference);){
            expectedContent = expectedContentInputstream.readAllBytes();
        }
        catch (Throwable t) {
            Assertions.fail((String)"Unable to read expected content for comparison", (Throwable)t);
        }
        Assertions.assertArrayEquals((byte[])expectedContent, (byte[])actualContent);
    }
}

