/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.test.action.load;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.deltafi.actionkit.action.DataAmendedResult;
import org.deltafi.actionkit.action.load.LoadResult;
import org.deltafi.actionkit.action.load.SplitResult;
import org.deltafi.common.types.Content;
import org.deltafi.common.types.Domain;
import org.deltafi.common.types.SplitEvent;
import org.deltafi.test.action.ActionTest;
import org.deltafi.test.action.Child;
import org.deltafi.test.action.IOContent;
import org.deltafi.test.action.load.LoadActionTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={MockitoExtension.class})
public abstract class LoadActionTest
extends ActionTest {
    private static final Logger log = LoggerFactory.getLogger(LoadActionTest.class);

    private Domain getDomain(List<Domain> domains, String name) {
        return domains.stream().filter(d -> d.getName().equals(name)).findFirst().orElseGet(() -> (Domain)Assertions.fail((String)("Could not find domain named " + name + " to normalize domain data")));
    }

    public void assertLoadResult(LoadActionTestCase testCase, LoadResult loadResult) {
        LoadResult expectedResult = new LoadResult(this.context(), Collections.singletonList(Content.newBuilder().contentReference(testCase.getExpectedContentReference()).build()));
        expectedResult.addMetadata(testCase.getResultMetadata());
        if (testCase.getOutputDomain() != null) {
            ((Stream)testCase.getOutputDomain().entrySet().stream().sequential()).forEach(kv -> {
                byte[] domainContent = this.getTestResourceBytesOrNull(testCase.getTestName(), (String)kv.getKey());
                String output = domainContent == null ? null : new String(domainContent, StandardCharsets.UTF_8);
                expectedResult.addDomain(((String)kv.getKey()).startsWith("domain.") ? ((String)kv.getKey()).substring(7) : (String)kv.getKey(), output, (String)kv.getValue());
            });
            if (expectedResult.getDomains().size() != loadResult.getDomains().size()) {
                Assertions.fail((String)("Expected domains size " + expectedResult.getDomains().size() + " does not match actual Domains size " + loadResult.getDomains().size()));
            }
            List expectedDomains = expectedResult.getDomains();
            List domains = loadResult.getDomains().stream().map(Domain::getName).map(n -> this.getDomain(expectedDomains, (String)n)).collect(Collectors.toList());
            expectedDomains.clear();
            expectedDomains.addAll(domains);
        }
        List<byte[]> expectedContent = Collections.emptyList();
        if (!testCase.getOutputs().isEmpty()) {
            expectedContent = this.getExpectedContentOutputNormalized((DataAmendedResult)expectedResult, (DataAmendedResult)loadResult, testCase, testCase.getOutputs());
        }
        String expectedEvent = this.normalizeData(expectedResult.toEvent().toString());
        String outputEvent = this.normalizeData(loadResult.toEvent().toString());
        Assertions.assertEquals((Object)expectedEvent, (Object)outputEvent);
        List<byte[]> actualContent = loadResult.getContent().stream().map(this::getContent).collect(Collectors.toList());
        this.assertContentIsEqual(expectedContent, actualContent);
    }

    public void assertSplitResult(LoadActionTestCase testCase, SplitResult splitResult) {
        SplitResult expectedResult = new SplitResult(this.context());
        testCase.getOutputs().forEach(c -> {
            Assertions.assertTrue((boolean)(c instanceof Child));
            Child child = (Child)c;
            String name = child.getName().startsWith("split.") ? child.getName().substring(6) : child.getName();
            expectedResult.addChild(name, child.getFlow(), child.getMetadata(), this.getContents(Collections.singletonList(((IOContent.IOContentBuilder)((IOContent.IOContentBuilder)((IOContent.IOContentBuilder)IOContent.builder().name(child.getName())).contentType(child.getContentType())).metadata(child.getMetadata())).build()), testCase, "split."));
        });
        List<SplitEvent> ordered = this.orderListByAnother(splitResult.getSplitEvents(), expectedResult.getSplitEvents(), item -> item.getSourceInfo().getFilename());
        expectedResult.getSplitEvents().clear();
        expectedResult.getSplitEvents().addAll(ordered);
        String expectedEvent = this.normalizeData(expectedResult.toEvent().toString());
        String outputEvent = this.normalizeData(splitResult.toEvent().toString());
        Assertions.assertEquals((Object)expectedEvent, (Object)outputEvent);
    }

    public void execute(LoadActionTestCase testCase) {
        if (testCase.getExpectedResultType() == LoadResult.class) {
            this.executeLoadResult(testCase);
        } else if (testCase.getExpectedResultType() == SplitResult.class) {
            this.executeLoadSplitResult(testCase);
        } else {
            super.execute(testCase);
        }
    }

    public void executeLoadResult(LoadActionTestCase loadActionTestCase) {
        LoadResult result = this.execute(loadActionTestCase, LoadResult.class);
        this.assertLoadResult(loadActionTestCase, result);
    }

    public void executeLoadSplitResult(LoadActionTestCase loadActionTestCase) {
        SplitResult result = this.execute(loadActionTestCase, SplitResult.class);
        this.assertSplitResult(loadActionTestCase, result);
    }

    protected byte[] getTestResourceBytesOrNull(String testCaseName, String file) {
        byte[] byArray;
        block8: {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.getClass().getSimpleName() + "/" + testCaseName + "/" + file);
            try {
                byte[] byArray2 = byArray = inputStream == null ? null : inputStream.readAllBytes();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return null;
                }
            }
            inputStream.close();
        }
        return byArray;
    }
}

