/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.test.action.transform;

import java.util.List;
import java.util.stream.Collectors;
import org.deltafi.actionkit.action.DataAmendedResult;
import org.deltafi.actionkit.action.transform.TransformResult;
import org.deltafi.test.action.ActionTest;
import org.deltafi.test.action.transform.TransformActionTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={MockitoExtension.class})
public abstract class TransformActionTest
extends ActionTest {
    private static final Logger log = LoggerFactory.getLogger(TransformActionTest.class);

    public void execute(TransformActionTestCase testCase) {
        if (testCase.getExpectedResultType() == TransformResult.class) {
            this.executeTransformResult(testCase);
        } else {
            super.execute(testCase);
        }
    }

    private void executeTransformResult(TransformActionTestCase testCase) {
        TransformResult result = this.execute(testCase, TransformResult.class);
        this.assertTransformResult(testCase, result);
    }

    private void assertTransformResult(TransformActionTestCase testCase, TransformResult result) {
        TransformResult expectedResult = new TransformResult(this.context());
        List<byte[]> expectedContent = this.getExpectedContentOutputNormalized((DataAmendedResult)expectedResult, (DataAmendedResult)result, testCase, testCase.getOutputs());
        expectedResult.addMetadata(testCase.getResultMetadata());
        String expectedEvent = this.normalizeData(expectedResult.toEvent().toString());
        String outputEvent = this.normalizeData(result.toEvent().toString());
        Assertions.assertEquals((Object)expectedEvent, (Object)outputEvent);
        List<byte[]> actualContent = result.getContent().stream().map(this::getContent).collect(Collectors.toList());
        this.assertContentIsEqual(expectedContent, actualContent);
    }
}

