/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.timestamp.connector;

import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.timestamp.connector.Connector;
import org.demoiselle.signer.timestamp.connector.HttpConnector;
import org.demoiselle.signer.timestamp.connector.SocketConnector;
import org.demoiselle.signer.timestamp.enumeration.ConnectionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConnectorFactory.class);
    private static MessagesBundle timeStampMessagesBundle = new MessagesBundle();

    public static Connector buildConnector(ConnectionType connectionType) {
        switch (connectionType) {
            case HTTP: {
                logger.debug(timeStampMessagesBundle.getString("info.timestamp.connection.http"));
                return new HttpConnector();
            }
            case SOCKET: {
                logger.debug(timeStampMessagesBundle.getString("info.timestamp.connection.socket"));
                return new SocketConnector();
            }
        }
        logger.debug(timeStampMessagesBundle.getString("info.timestamp.connection.socket"));
        return new SocketConnector();
    }

    private ConnectorFactory() {
    }
}

