/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.core;

import com.thoughtworks.xstream.XStream;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.devocative.adroit.ConfigUtil;
import org.devocative.adroit.IConfigKey;
import org.devocative.adroit.StringEncryptorUtil;
import org.devocative.demeter.DSystemException;
import org.devocative.demeter.DemeterConfigKey;
import org.devocative.demeter.IDemeterCoreEventListener;
import org.devocative.demeter.core.DbDiffVO;
import org.devocative.demeter.core.DemeterCoreHelper;
import org.devocative.demeter.core.EStartupStep;
import org.devocative.demeter.core.StepResultVO;
import org.devocative.demeter.core.xml.XEntity;
import org.devocative.demeter.core.xml.XModule;
import org.devocative.demeter.iservice.ApplicationLifecyclePriority;
import org.devocative.demeter.iservice.IApplicationLifecycle;
import org.devocative.demeter.iservice.persistor.IPersistorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DemeterCore {
    public static final String CONFIG_PROFILE = "dmtProfile";
    private static final Logger logger = LoggerFactory.getLogger(DemeterCore.class);
    private final Map<String, XModule> MODULES = new LinkedHashMap<String, XModule>();
    private final Set<String> MODULE_SHORT_NAMES = new LinkedHashSet<String>();
    private ClassPathXmlApplicationContext appCtx;
    private final Map<ApplicationLifecyclePriority, Map<String, IApplicationLifecycle>> APP_LIFECYCLE_BEANS = new HashMap<ApplicationLifecyclePriority, Map<String, IApplicationLifecycle>>();
    private boolean shuted = false;
    private StepResultVO MAIN_STARTUP = new StepResultVO(EStartupStep.Begin);
    private final List<IDemeterCoreEventListener> DEMETER_CORE_EVENTS = new ArrayList<IDemeterCoreEventListener>();
    private Date startUpDate;
    private static DemeterCore INSTANCE;

    public static DemeterCore get() {
        if (INSTANCE == null || DemeterCore.INSTANCE.shuted) {
            INSTANCE = new DemeterCore();
        }
        return INSTANCE;
    }

    public void init() {
        if (this.MAIN_STARTUP.getStep() == EStartupStep.Begin) {
            this.startUntil(EStartupStep.End);
            this.checkAndExecuteAfterSuccess();
        }
    }

    public void resume() {
        logger.info("## RESUMING");
        if (!this.isStartedSuccessfully()) {
            this.startUntil(EStartupStep.End);
            this.checkAndExecuteAfterSuccess();
        }
    }

    public synchronized void shutdown() {
        if (!this.shuted) {
            this.shutdownApplicationLifecycle();
            this.appCtx.close();
            logger.info("### MODULE LOADER SHUTDOWNED");
            INSTANCE = null;
        }
        this.shuted = true;
    }

    public void registerSpringBean(String beanName, Object bean) {
        ConfigurableListableBeanFactory beanFactory = this.appCtx.getBeanFactory();
        beanFactory.registerSingleton(beanName, bean);
        beanFactory.autowireBean(bean);
    }

    public void generatePersistorSchemaDiff() {
        this.startUntil(EStartupStep.BeansStartup);
        if (!this.MAIN_STARTUP.isSuccessful()) {
            logger.error("=======================================");
            logger.error("== {}", (Throwable)this.MAIN_STARTUP.getError());
            logger.error("=======================================");
        }
        Map persistorServiceMap = this.appCtx.getBeansOfType(IPersistorService.class);
        for (Map.Entry entry : persistorServiceMap.entrySet()) {
            logger.info("Persistor init: {}", entry.getKey());
            ((IPersistorService)entry.getValue()).init();
        }
        for (Map.Entry entry : persistorServiceMap.entrySet()) {
            logger.info("Persistor schema diff: {}", entry.getKey());
            ((IPersistorService)entry.getValue()).generateSchemaDiff();
        }
        for (Map.Entry entry : persistorServiceMap.entrySet()) {
            logger.info("Persistor shutdown: {}", entry.getKey());
            ((IPersistorService)entry.getValue()).shutdown();
        }
        this.appCtx.close();
    }

    public void applyAllDbDiffs() {
        this.startUntil(EStartupStep.Database);
        DemeterCoreHelper.initDatabase(new ArrayList<String>(this.MODULE_SHORT_NAMES), true);
    }

    public void applyDbDiffs(List<DbDiffVO> diffs) {
        DemeterCoreHelper.applyDbDiffs(diffs);
    }

    public void addCoreEvent(IDemeterCoreEventListener listener) {
        this.DEMETER_CORE_EVENTS.add(listener);
    }

    public ApplicationContext getApplicationContext() {
        return this.appCtx;
    }

    public Map<String, XModule> getModules() {
        return new LinkedHashMap<String, XModule>(this.MODULES);
    }

    public boolean isStartedSuccessfully() {
        return this.MAIN_STARTUP.getStep() == EStartupStep.End;
    }

    public StepResultVO getLatestStat() {
        return new StepResultVO(this.MAIN_STARTUP.getStep(), this.MAIN_STARTUP.getError());
    }

    public List<DbDiffVO> getDbDiffs() {
        return DemeterCoreHelper.getDbDiffs(new ArrayList<String>(this.MODULE_SHORT_NAMES));
    }

    public List<String> getEntities() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, XModule> moduleEntry : this.MODULES.entrySet()) {
            XModule xModule = moduleEntry.getValue();
            if (xModule.getEntities() == null) continue;
            for (XEntity xEntity : xModule.getEntities()) {
                list.add(xEntity.getType());
            }
        }
        return list;
    }

    public Date getStartUpDate() {
        return this.startUpDate;
    }

    private void startUntil(EStartupStep last) {
        StepResultVO result = null;
        EStartupStep step = this.MAIN_STARTUP.getStep();
        while (step.ordinal() < last.ordinal()) {
            logger.info("## Executing Step: [{}]", (Object)EStartupStep.next(step));
            result = this.doNext(step);
            logger.info("## Executed Step: [{}], successful=[{}]", (Object)EStartupStep.next(step), (Object)result.isSuccessful());
            step = result.getStep();
            if (result.isSuccessful()) continue;
        }
        if (result != null) {
            this.MAIN_STARTUP = result;
        }
    }

    private StepResultVO doNext(EStartupStep current) {
        Exception error = null;
        EStartupStep next = EStartupStep.next(current);
        try {
            switch (next) {
                case Begin: {
                    break;
                }
                case Config: {
                    this.initConfig();
                    break;
                }
                case EncDec: {
                    this.initEncDec();
                    break;
                }
                case Modules: {
                    this.initModules();
                    break;
                }
                case Spring: {
                    this.initSpringContext();
                    break;
                }
                case PersistenceServices: {
                    this.initPersistorServices();
                    break;
                }
                case Database: {
                    this.initDatabase();
                    break;
                }
                case BeansStartup: {
                    this.initBeansStartup();
                    break;
                }
                case End: {
                    this.initEnd();
                    break;
                }
                default: {
                    throw new DSystemException("Unhandled Step: " + (Object)((Object)current));
                }
            }
        }
        catch (Exception e) {
            logger.warn("!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*");
            logger.warn("!! Step = [{}]", (Object)next, (Object)e);
            logger.warn("!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*");
            error = e;
        }
        return new StepResultVO(next, error);
    }

    private void checkAndExecuteAfterSuccess() {
        if (this.isStartedSuccessfully()) {
            for (IDemeterCoreEventListener demeterUp : this.DEMETER_CORE_EVENTS) {
                demeterUp.afterUpSuccessfully();
            }
            logger.info("### MODULE LOADER INITED");
        }
    }

    private void initConfig() {
        String configFile = "/config.properties";
        String property = System.getProperty(CONFIG_PROFILE);
        if (property != null) {
            configFile = String.format("/config_%s.properties", property);
        }
        logger.info(">>>> C O N F I G   F I L E: {}", (Object)configFile);
        ConfigUtil.load((InputStream)this.getClass().getResourceAsStream(configFile));
    }

    private void initEncDec() {
        boolean enableSecurity = true;
        try {
            enableSecurity = ConfigUtil.getBoolean((IConfigKey)DemeterConfigKey.EnabledSecurity);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        StringEncryptorUtil.setBypassSecurity((!enableSecurity ? 1 : 0) != 0);
        if (ConfigUtil.getBoolean((IConfigKey)DemeterConfigKey.SecurityKeyStoreEnabled).booleanValue()) {
            String paramValue;
            String tokenValue = System.getProperty(ConfigUtil.getString((IConfigKey)DemeterConfigKey.SecurityKeyStoreToken));
            if (tokenValue == null) {
                tokenValue = System.getenv(ConfigUtil.getString((IConfigKey)DemeterConfigKey.SecurityKeyStoreToken));
            }
            if ((paramValue = System.getProperty(ConfigUtil.getString((IConfigKey)DemeterConfigKey.SecurityKeyStoreParam))) == null) {
                paramValue = System.getenv(ConfigUtil.getString((IConfigKey)DemeterConfigKey.SecurityKeyStoreParam));
            }
            if (tokenValue != null && paramValue != null) {
                String entry = ConfigUtil.getString((IConfigKey)DemeterConfigKey.SecurityKeyStoreEntry);
                try {
                    StringEncryptorUtil.init((InputStream)this.getClass().getResourceAsStream("/demeter.ks"), (String)tokenValue, (String)entry, (String)paramValue);
                    logger.info("StringEncryptorUtil INITED");
                }
                catch (Exception e) {
                    logger.error("StringEncryptorUtil Init Error: " + e);
                }
            } else {
                logger.error("StringEncryptorUtil Init Problem: KeyStoreToken=[{}] KeyStoreParam=[{}]", (Object)(tokenValue != null ? 1 : 0), (Object)(paramValue != null ? 1 : 0));
            }
        }
    }

    private void initModules() {
        List<String> modulesName;
        XStream xStream = new XStream();
        xStream.processAnnotations(XModule.class);
        xStream.alias("dependency", String.class);
        if (ConfigUtil.hasKey((IConfigKey)DemeterConfigKey.Modules)) {
            modulesName = ConfigUtil.getList((IConfigKey)DemeterConfigKey.Modules);
            logger.info("List of Modules by Config: {}", modulesName);
        } else {
            modulesName = this.findModulesNameInClasspath();
            logger.info("List of Modules Found in Classpath: {}", modulesName);
        }
        modulesName.remove("Demeter");
        modulesName.add(0, "Demeter");
        if (modulesName.remove("Deploy")) {
            modulesName.add("Deploy");
        }
        logger.info("Final List of Modules: {}", modulesName);
        for (String moduleName : modulesName) {
            String modulePath = String.format("/dmodule/%s.xml", moduleName);
            InputStream moduleXMLResource = this.getClass().getResourceAsStream(modulePath);
            if (moduleXMLResource != null) {
                XModule xModule = (XModule)xStream.fromXML(moduleXMLResource);
                logger.info("Module's XML Loaded: {}", (Object)moduleName);
                if (this.MODULE_SHORT_NAMES.contains(xModule.getShortName())) {
                    throw new DSystemException("Duplicate module short name: " + xModule.getShortName());
                }
                this.MODULE_SHORT_NAMES.add(xModule.getShortName());
                this.MODULES.put(moduleName, xModule);
                this.loadConfigKeys(xModule);
                continue;
            }
            throw new DSystemException("Invalid Module Path: " + modulePath);
        }
    }

    private void initSpringContext() {
        String[] springConfigLocations = new String[this.MODULES.size()];
        String springPrefixConfig = "local";
        int i = 0;
        for (Map.Entry<String, XModule> moduleEntry : this.MODULES.entrySet()) {
            String springXML = String.format("/%s%s.xml", springPrefixConfig, moduleEntry.getValue().getShortName().toUpperCase());
            logger.info("Loading Spring Config Location: {}", (Object)springXML);
            springConfigLocations[i] = springXML;
            ++i;
        }
        this.appCtx = new ClassPathXmlApplicationContext(springConfigLocations);
        for (String bean : this.appCtx.getBeanDefinitionNames()) {
            logger.info("\tSPRING BEAN: {}", (Object)bean);
        }
    }

    private void initPersistorServices() {
        Map persistors = this.appCtx.getBeansOfType(IPersistorService.class);
        ArrayList<Class> dmtPersistorServiceEntities = new ArrayList<Class>();
        for (Map.Entry<String, XModule> moduleEntry : this.MODULES.entrySet()) {
            XModule module = moduleEntry.getValue();
            if (module.getEntities() == null || module.getEntities().size() <= 0) continue;
            dmtPersistorServiceEntities.addAll(this.loadEntities(module.getEntities()));
            logger.info("Module has {} entities.", (Object)module.getEntities().size());
        }
        ((IPersistorService)persistors.get("dmtPersistorService")).setInitData(dmtPersistorServiceEntities, "dmt");
        logger.info("Demeter persistor initialized with [{}] entities.", (Object)dmtPersistorServiceEntities.size());
    }

    private void initDatabase() {
        DemeterCoreHelper.initDatabase(new ArrayList<String>(this.MODULE_SHORT_NAMES), false);
    }

    private void initBeansStartup() {
        Map beansOfType = this.appCtx.getBeansOfType(IApplicationLifecycle.class);
        for (Map.Entry entry : beansOfType.entrySet()) {
            if (((IApplicationLifecycle)entry.getValue()).getLifecyclePriority() == null) {
                throw new DSystemException("IApplicationLifecycle has no priority: " + (String)entry.getKey());
            }
            if (!this.APP_LIFECYCLE_BEANS.containsKey(((IApplicationLifecycle)entry.getValue()).getLifecyclePriority())) {
                this.APP_LIFECYCLE_BEANS.put(((IApplicationLifecycle)entry.getValue()).getLifecyclePriority(), new HashMap());
            }
            this.APP_LIFECYCLE_BEANS.get(((IApplicationLifecycle)entry.getValue()).getLifecyclePriority()).put((String)entry.getKey(), (IApplicationLifecycle)entry.getValue());
        }
        for (ApplicationLifecyclePriority priority : ApplicationLifecyclePriority.values()) {
            if (!this.APP_LIFECYCLE_BEANS.containsKey(priority)) continue;
            Map<String, IApplicationLifecycle> lifecycleMap = this.APP_LIFECYCLE_BEANS.get(priority);
            for (Map.Entry<String, IApplicationLifecycle> entry : lifecycleMap.entrySet()) {
                entry.getValue().init();
                logger.info("Application Lifecycle Priority [{}] init(): bean=[{}]", (Object)priority, (Object)entry.getKey());
            }
        }
        Map iPersistorServiceMap = this.appCtx.getBeansOfType(IPersistorService.class);
        iPersistorServiceMap.values().forEach(IPersistorService::endSession);
    }

    private void initEnd() {
        if (ConfigUtil.hasKey((IConfigKey)DemeterConfigKey.StartupGroovyScript)) {
            File file = new File(ConfigUtil.getString((IConfigKey)DemeterConfigKey.StartupGroovyScript));
            if (file.exists()) {
                try {
                    GroovyShell shell = new GroovyShell();
                    Script parse = shell.parse(file);
                    parse.run();
                    logger.info("Script executed successfully: [{}]", (Object)ConfigUtil.getString((IConfigKey)DemeterConfigKey.StartupGroovyScript));
                }
                catch (Exception e) {
                    logger.error("initEnd: script file = [{}]", (Object)ConfigUtil.getString((IConfigKey)DemeterConfigKey.StartupGroovyScript), (Object)e);
                }
            } else {
                logger.error("Script file not found: {}", (Object)ConfigUtil.getString((IConfigKey)DemeterConfigKey.StartupGroovyScript));
            }
        }
        this.startUpDate = new Date();
    }

    private void shutdownApplicationLifecycle() {
        List<ApplicationLifecyclePriority> priorities = Arrays.asList(ApplicationLifecyclePriority.values());
        Collections.reverse(priorities);
        for (ApplicationLifecyclePriority priority : priorities) {
            if (!this.APP_LIFECYCLE_BEANS.containsKey(priority)) continue;
            Map<String, IApplicationLifecycle> lifecycleMap = this.APP_LIFECYCLE_BEANS.get(priority);
            for (Map.Entry<String, IApplicationLifecycle> entry : lifecycleMap.entrySet()) {
                entry.getValue().shutdown();
                logger.info("Application Lifecycle Priority [{}] shutdown(): bean=[{}]", (Object)priority, (Object)entry.getKey());
            }
        }
    }

    private List<Class> loadEntities(List<XEntity> entities) {
        ArrayList<Class> classes = new ArrayList<Class>();
        for (XEntity entity : entities) {
            try {
                classes.add(Class.forName(entity.getType()));
            }
            catch (ClassNotFoundException e) {
                throw new DSystemException("Entity class not found: " + entity);
            }
        }
        return classes;
    }

    private void loadConfigKeys(XModule xModule) {
        block5: {
            try {
                if (xModule.getConfigKeyClass() != null) {
                    Class<?> enumClass = Class.forName(xModule.getConfigKeyClass());
                    if (enumClass.isEnum()) {
                        ?[] enumConstants;
                        for (Object enumConstant : enumConstants = enumClass.getEnumConstants()) {
                            ConfigUtil.add((IConfigKey)((IConfigKey)enumConstant));
                        }
                        break block5;
                    }
                    throw new DSystemException("ConfigKey class must be enum for module: " + xModule.getShortName());
                }
                throw new DSystemException("ConfigKey class not found for module: " + xModule.getShortName());
            }
            catch (Exception e) {
                logger.error(String.format("Loading module [%s] config keys", xModule.getShortName()), (Throwable)e);
            }
        }
    }

    private List<String> findModulesNameInClasspath() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("dmodule/");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                logger.info("Searching for Modules: URL = {}", (Object)url);
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    Collection files = FileUtils.listFiles((File)new File(url.getPath()), (String[])new String[]{"xml"}, (boolean)false);
                    for (File file : files) {
                        String name = file.getName();
                        result.add(name.substring(0, name.length() - 4));
                    }
                    continue;
                }
                if ("jar".equals(protocol)) {
                    String jarPath = url.getPath().substring(5, url.getPath().indexOf("!"));
                    String dirPath = url.getPath().substring(url.getPath().indexOf("!") + 2);
                    JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
                    Throwable throwable = null;
                    try {
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            String name = entries.nextElement().getName();
                            if (!name.startsWith(dirPath) || !name.endsWith(".xml")) continue;
                            result.add(name.substring(8, name.length() - 4));
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jar == null) continue;
                        if (throwable != null) {
                            try {
                                jar.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jar.close();
                        continue;
                    }
                }
                throw new DSystemException("Invalid Protocol for Module Search: " + protocol);
            }
        }
        catch (IOException e) {
            throw new DSystemException((Throwable)e);
        }
        return result;
    }
}

