/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.devocative.demeter.core.DemeterCore;
import org.devocative.demeter.core.xml.XDPage;
import org.devocative.demeter.core.xml.XDTask;
import org.devocative.demeter.core.xml.XModule;
import org.devocative.demeter.iservice.IDemeterCoreService;
import org.devocative.demeter.vo.core.DModuleInfoVO;
import org.devocative.demeter.vo.core.DPageInfoVO;
import org.devocative.demeter.vo.core.DTaskInfoVO;

public class DemeterCoreService
implements IDemeterCoreService {
    private List<DModuleInfoVO> modules;

    public List<DModuleInfoVO> getModules() {
        if (this.modules == null) {
            this.modules = new ArrayList<DModuleInfoVO>();
            Collection<XModule> xModules = DemeterCore.get().getModules().values();
            for (XModule xModule : xModules) {
                ArrayList<DPageInfoVO> pages = new ArrayList<DPageInfoVO>();
                if (xModule.getDPages() != null) {
                    for (XDPage xdPage : xModule.getDPages()) {
                        pages.add(new DPageInfoVO(xdPage.getType(), xdPage.getTitle(), xdPage.getUri(), xdPage.getInMenu(), xdPage.getRoles()));
                    }
                }
                ArrayList<DTaskInfoVO> tasks = new ArrayList<DTaskInfoVO>();
                if (xModule.getTasks() != null) {
                    for (XDTask xdTask : xModule.getTasks()) {
                        tasks.add(new DTaskInfoVO(xdTask.getType(), xdTask.getCronExpression(), xdTask.getCalendar()));
                    }
                }
                this.modules.add(new DModuleInfoVO(xModule.getShortName(), xModule.getPrivilegeKeyClass(), pages, tasks));
            }
        }
        return this.modules;
    }

    public <T> Map<String, T> getBeansOfType(Class<T> var1) {
        return DemeterCore.get().getApplicationContext().getBeansOfType(var1);
    }

    public <T> T getBean(Class<T> var1) {
        return (T)DemeterCore.get().getApplicationContext().getBean(var1);
    }

    public Object getBean(String var1) {
        return DemeterCore.get().getApplicationContext().getBean(var1);
    }

    public Date getStartUpDate() {
        return DemeterCore.get().getStartUpDate();
    }
}

