/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.devocative.adroit.ConfigUtil;
import org.devocative.adroit.IConfigKey;
import org.devocative.adroit.sql.DatabaseType;
import org.devocative.adroit.sql.info.IDatabaseInfo;
import org.devocative.demeter.DSystemException;
import org.devocative.demeter.DemeterConfigKey;
import org.devocative.demeter.core.DbDiffVO;
import org.devocative.demeter.core.DemeterCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DemeterCoreHelper {
    private static final Logger logger = LoggerFactory.getLogger(DemeterCoreHelper.class);

    DemeterCoreHelper() {
    }

    static void initDatabase(List<String> modules, boolean force) {
        block18: {
            String handler = ConfigUtil.getString((IConfigKey)DemeterConfigKey.DatabaseDiffHandler).toLowerCase();
            logger.info("Init Database, Handler=[{}]", (Object)handler);
            if ("script".equals(handler) || "auto".equals(handler)) {
                try (Connection connection = DemeterCoreHelper.createConnection();){
                    String dbType = DemeterCoreHelper.findDBType(connection);
                    if (dbType != null) {
                        List<DbDiffVO> diffs = DemeterCoreHelper.findDiffs(connection, modules, dbType);
                        logger.info("Database Found Diff(s): no = [{}]", (Object)diffs.size());
                        if (diffs.isEmpty()) break block18;
                        if (force || "auto".equals(handler)) {
                            DemeterCoreHelper.applyDiffs(connection, diffs);
                            break block18;
                        }
                        throw new DSystemException("Database Diff Found: Numbers=" + diffs.size());
                    }
                    throw new DSystemException("Unknown Database Type for Handling Database Change Script");
                }
                catch (IOException | SQLException e) {
                    throw new DSystemException((Throwable)e);
                }
            }
            if ("hbm2ddl".equals(handler)) {
                ConfigUtil.updateKey((String)"dmt.db.update.ddl", (String)"true");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<DbDiffVO> getDbDiffs(List<String> modules) {
        try (Connection connection = DemeterCoreHelper.createConnection();){
            List<DbDiffVO> list = DemeterCoreHelper.findDiffs(connection, modules, DemeterCoreHelper.findDBType(connection));
            return list;
        }
        catch (IOException | SQLException e) {
            throw new DSystemException((Throwable)e);
        }
    }

    static void applyDbDiffs(List<DbDiffVO> dbDiffVOs) {
        try (Connection connection = DemeterCoreHelper.createConnection();){
            DemeterCoreHelper.applyDiffs(connection, dbDiffVOs);
        }
        catch (SQLException e) {
            throw new DSystemException((Throwable)e);
        }
    }

    private static void applyDiffs(Connection connection, List<DbDiffVO> diffs) throws SQLException {
        for (DbDiffVO diff : diffs) {
            String[] statements;
            logger.info("Database Apply Diff: [{}]", (Object)diff.getFile());
            String sql = diff.getSql();
            sql = sql.replaceAll("[-][-].+?[\r]?[\n]", "");
            for (String statement : statements = sql.split("[;]")) {
                if ((statement = statement.trim()).isEmpty()) continue;
                Statement st = connection.createStatement();
                st.execute(statement);
                st.close();
            }
            PreparedStatement select = connection.prepareStatement("select count(1) from z_dmt_sql_apply where c_module=? and c_version=?");
            select.setString(1, diff.getModule());
            select.setString(2, diff.getVersion());
            ResultSet rs = select.executeQuery();
            rs.next();
            long cnt = rs.getLong(1);
            if (cnt != 0L) continue;
            logger.warn("Insert SQL Apply: module=[{}] version=[{}]", (Object)diff.getModule(), (Object)diff.getVersion());
            PreparedStatement insert = connection.prepareStatement("insert into z_dmt_sql_apply(c_module,c_version,c_file,d_apply) VALUES(?,?,?,?)");
            insert.setString(1, diff.getModule());
            insert.setString(2, diff.getVersion());
            insert.setString(3, diff.getFile());
            insert.setDate(4, new Date(new java.util.Date().getTime()));
            insert.executeUpdate();
        }
    }

    private static List<DbDiffVO> findDiffs(Connection connection, List<String> modules, String dbType) throws IOException, SQLException {
        ArrayList<DbDiffVO> result = new ArrayList<DbDiffVO>();
        Map<String, List<String>> applied = DemeterCoreHelper.findApplied(connection);
        for (String module : modules) {
            URL verUrl = DemeterCoreHelper.class.getResource(String.format("/sql/%s_%s.txt", module = module.toLowerCase(), dbType));
            if (verUrl != null) {
                LineIterator iterator = IOUtils.lineIterator((InputStream)verUrl.openStream(), (String)"UTF-8");
                while (iterator.hasNext()) {
                    String version = iterator.next().trim();
                    if (version.isEmpty() || applied.containsKey(module) && applied.get(module).contains(version)) continue;
                    String sqlFile = String.format("/sql/%s_%s_%s.sql", module, dbType, version);
                    URL sqlUrl = DemeterCore.class.getResource(sqlFile);
                    if (sqlUrl != null) {
                        String sql = IOUtils.toString((URL)sqlUrl, (String)"UTF-8");
                        sql = sql + "\n\n-- Add SQL_Apply\n";
                        sql = sql + String.format("insert into z_dmt_sql_apply(c_module,c_version,c_file,d_apply) VALUES('%s','%s','%s',sysdate);", module, version, sqlFile);
                        result.add(new DbDiffVO(module, version, sqlFile, sql));
                        continue;
                    }
                    throw new DSystemException("SQL file not found: " + sqlFile);
                }
                iterator.close();
                continue;
            }
            throw new DSystemException(String.format("'%s_%s.txt' File Not Found: ", module, dbType));
        }
        return result;
    }

    private static Map<String, List<String>> findApplied(Connection connection) {
        LinkedHashMap<String, List<String>> applied = new LinkedHashMap<String, List<String>>();
        try (Statement st = connection.createStatement();){
            ResultSet rs = st.executeQuery("select c_module, c_version from z_dmt_sql_apply");
            while (rs.next()) {
                String module = rs.getString("c_module");
                String version = rs.getString("c_version");
                if (!applied.containsKey(module)) {
                    applied.put(module, new ArrayList());
                }
                ((List)applied.get(module)).add(version);
            }
        }
        catch (SQLException e) {
            logger.warn("DemeterCoreHelper.findApplied: {}", (Object)e.getMessage());
        }
        return applied;
    }

    private static Connection createConnection() {
        try {
            Class.forName(ConfigUtil.getString((boolean)true, (String)"dmt.db.driver"));
            return DriverManager.getConnection(ConfigUtil.getString((boolean)true, (String)"dmt.db.url"), ConfigUtil.getString((boolean)true, (String)"dmt.db.username"), ConfigUtil.getString((String)"dmt.db.password", (String)""));
        }
        catch (Exception e) {
            throw new DSystemException((Throwable)e);
        }
    }

    private static String findDBType(Connection connection) {
        String result = null;
        IDatabaseInfo databaseInfo = DatabaseType.find((Connection)connection);
        if (databaseInfo != null) {
            result = databaseInfo.getName().toLowerCase();
        }
        if (ConfigUtil.hasKey((IConfigKey)DemeterConfigKey.DatabaseType)) {
            result = ConfigUtil.getString((IConfigKey)DemeterConfigKey.DatabaseType).toLowerCase();
        }
        return result;
    }
}

