/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.dropwizard.sentry.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.filter.Filter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import io.dropwizard.logging.AbstractAppenderFactory;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import io.sentry.Sentry;
import io.sentry.SentryOptions;
import io.sentry.logback.SentryAppender;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.dhatim.dropwizard.sentry.SentryConfigurator;
import org.dhatim.dropwizard.sentry.filters.DroppingSentryLoggingFilter;

@JsonTypeName(value="sentry")
public class SentryAppenderFactory
extends AbstractAppenderFactory<ILoggingEvent> {
    private static final String APPENDER_NAME = "dropwizard-sentry";
    @NotNull
    @JsonProperty
    public String dsn = null;
    @JsonProperty
    public String environment = null;
    @JsonProperty
    public Map<String, String> tags = null;
    @JsonProperty
    public String release = null;
    @JsonProperty
    public String serverName = null;
    @JsonProperty
    public List<String> inAppIncludes = null;
    @JsonProperty
    public List<String> inAppExcludes = null;
    @JsonProperty
    public String configurator = null;

    public Appender<ILoggingEvent> build(LoggerContext context, String applicationName, LayoutFactory<ILoggingEvent> layoutFactory, LevelFilterFactory<ILoggingEvent> levelFilterFactory, AsyncAppenderFactory<ILoggingEvent> asyncAppenderFactory) {
        Preconditions.checkNotNull((Object)context);
        SentryOptions options = new SentryOptions();
        options.setDsn(this.dsn);
        Optional.ofNullable(this.environment).ifPresent(arg_0 -> ((SentryOptions)options).setEnvironment(arg_0));
        Optional.ofNullable(this.tags).ifPresent(tags -> tags.forEach((arg_0, arg_1) -> ((SentryOptions)options).setTag(arg_0, arg_1)));
        Optional.ofNullable(this.release).ifPresent(arg_0 -> ((SentryOptions)options).setRelease(arg_0));
        Optional.ofNullable(this.serverName).ifPresent(arg_0 -> ((SentryOptions)options).setServerName(arg_0));
        Optional.ofNullable(this.inAppIncludes).ifPresent(inAppIncludes -> inAppIncludes.forEach(arg_0 -> ((SentryOptions)options).addInAppInclude(arg_0)));
        Optional.ofNullable(this.inAppExcludes).ifPresent(inAppExcludes -> inAppExcludes.forEach(arg_0 -> ((SentryOptions)options).addInAppExclude(arg_0)));
        Optional.ofNullable(this.configurator).ifPresent(configurator -> {
            try {
                Class<?> klass = Class.forName(configurator);
                if (!SentryConfigurator.class.isAssignableFrom(klass)) {
                    throw new IllegalArgumentException("configurator class " + configurator + " does not implement " + SentryConfigurator.class.getName());
                }
                SentryConfigurator sentryConfigurator = (SentryConfigurator)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                sentryConfigurator.configure(options);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("configurator class " + configurator + " not found", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("configurator class " + configurator + " does not define a default constructor", e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalArgumentException("cannot invoke default constructor on configurator class " + configurator, e);
            }
        });
        Sentry.close();
        SentryAppender appender = new SentryAppender();
        appender.setOptions(options);
        appender.setName(APPENDER_NAME);
        appender.setContext((Context)context);
        appender.setMinimumBreadcrumbLevel(this.threshold);
        appender.setMinimumEventLevel(this.threshold);
        appender.addFilter(levelFilterFactory.build(this.threshold));
        this.getFilterFactories().forEach(f -> appender.addFilter(f.build()));
        appender.start();
        DroppingSentryLoggingFilter filter = new DroppingSentryLoggingFilter();
        filter.start();
        appender.addFilter((Filter)filter);
        return appender;
    }
}

