/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.model.Order;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.dhatim.Smooks;
import org.dhatim.SmooksException;
import org.dhatim.container.ExecutionContext;
import org.dhatim.event.ExecutionEventListener;
import org.dhatim.event.report.HtmlReportGenerator;
import org.dhatim.io.FileUtils;
import org.dhatim.payload.StringResult;
import org.xml.sax.SAXException;

public class Main {
    private static byte[] messageIn = Main.readInputMessage();
    private final Smooks smooks = new Smooks("smooks-config.xml");

    protected Main() throws IOException, SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String runSmooksTransform(ExecutionContext executionContext) throws IOException, SAXException, SmooksException {
        try {
            Locale defaultLocale = Locale.getDefault();
            Locale.setDefault(new Locale("en", "IE"));
            StringResult result = new StringResult();
            executionContext.setEventListener((ExecutionEventListener)new HtmlReportGenerator("target/report/report.html"));
            this.smooks.filterSource(executionContext, (Source)new StreamSource(new ByteArrayInputStream(messageIn)), new Result[]{result});
            Locale.setDefault(defaultLocale);
            String string = result.toString();
            return string;
        }
        finally {
            this.smooks.close();
        }
    }

    public static void main(String[] args) throws IOException, SAXException, SmooksException {
        System.out.println("\n\n==============Message In==============");
        System.out.println(new String(messageIn));
        System.out.println("======================================\n");
        Main.pause("The YAML input stream can be seen above.  Press 'enter' to see how this stream is transformed into DOM representation...");
        Main smooksMain = new Main();
        ExecutionContext executionContext = smooksMain.smooks.createExecutionContext();
        System.out.println("==============YAML as XML=============");
        System.out.println(smooksMain.runSmooksTransform(executionContext));
        System.out.println("======================================\n\n");
        Main.pause("Now press 'enter' to see how this XML loads into the Order Object graph...");
        System.out.println("==============YAML as Java Object Graph=============");
        System.out.println(executionContext.getBeanContext().getBean(Order.class));
        System.out.println("======================================\n\n");
        Main.pause("And that's it!  Press 'enter' to finish...");
    }

    private static byte[] readInputMessage() {
        try {
            return FileUtils.readFile((File)new File("input-message.yaml"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "<no-message/>".getBytes();
        }
    }

    private static void pause(String message) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("> " + message);
            in.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("\n");
    }

    public String runSmooksTransform() throws IOException, SAXException {
        ExecutionContext executionContext = this.smooks.createExecutionContext();
        return this.runSmooksTransform(executionContext);
    }
}

