/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic;

import eu.europa.esig.dss.ASiCContainerType;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.asic.ASiCParameters;
import eu.europa.esig.dss.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ASiCUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCUtils.class);
    private static final String MIME_TYPE = "mimetype";
    public static final String MIME_TYPE_COMMENT = "mimetype=";
    private static final String META_INF_FOLDER = "META-INF/";

    private ASiCUtils() {
    }

    public static boolean isSignature(String entryName) {
        return entryName.startsWith(META_INF_FOLDER) && entryName.contains("signature") && !entryName.contains("Manifest");
    }

    public static String getMimeTypeString(ASiCParameters asicParameters) {
        String asicParameterMimeType = asicParameters.getMimeType();
        String mimeTypeString = Utils.isStringBlank((String)asicParameterMimeType) ? (ASiCUtils.isASiCE(asicParameters) ? MimeType.ASICE.getMimeTypeString() : MimeType.ASICS.getMimeTypeString()) : asicParameterMimeType;
        return mimeTypeString;
    }

    public static boolean isASiCMimeType(MimeType asicMimeType) {
        return MimeType.ASICS.equals((Object)asicMimeType) || MimeType.ASICE.equals((Object)asicMimeType) || MimeType.ODT.equals((Object)asicMimeType) || MimeType.ODS.equals((Object)asicMimeType);
    }

    public static ASiCContainerType getASiCContainerType(MimeType asicMimeType) {
        if (MimeType.ASICS == asicMimeType) {
            return ASiCContainerType.ASiC_S;
        }
        if (MimeType.ASICE == asicMimeType || MimeType.ODT == asicMimeType || MimeType.ODS.equals((Object)asicMimeType)) {
            return ASiCContainerType.ASiC_E;
        }
        throw new IllegalArgumentException("Not allowed mimetype " + asicMimeType);
    }

    public static boolean isASiCE(ASiCParameters asicParameters) {
        return ASiCContainerType.ASiC_E.equals((Object)asicParameters.getContainerType());
    }

    public static boolean isASiCS(ASiCParameters asicParameters) {
        return ASiCContainerType.ASiC_S.equals((Object)asicParameters.getContainerType());
    }

    public static MimeType getMimeType(ASiCParameters asicParameters) {
        return ASiCUtils.isASiCE(asicParameters) ? MimeType.ASICE : MimeType.ASICS;
    }

    public static boolean isArchiveContainsCorrectSignatureExtension(DSSDocument toSignDocument, String extension) {
        boolean isSignatureTypeCorrect = true;
        InputStream is = null;
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            is = toSignDocument.openStream();
            zis = new ZipInputStream(is);
            while ((entry = zis.getNextEntry()) != null) {
                if (!ASiCUtils.isSignature(entry.getName())) continue;
                isSignatureTypeCorrect &= entry.getName().endsWith(extension);
            }
        }
        catch (IOException e) {
            try {
                throw new DSSException("Unable to analyze the archive content", (Throwable)e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(zis);
                Utils.closeQuietly((Closeable)is);
                throw throwable;
            }
        }
        Utils.closeQuietly((Closeable)zis);
        Utils.closeQuietly((Closeable)is);
        return isSignatureTypeCorrect;
    }

    public static boolean isArchive(List<DSSDocument> docs) {
        if (Utils.collectionSize(docs) == 1) {
            return ASiCUtils.isASiCContainer(docs.get(0));
        }
        return false;
    }

    public static boolean isASiCContainer(DSSDocument dssDocument) {
        byte[] preamble = new byte[2];
        InputStream is = null;
        try {
            is = dssDocument.openStream();
            int r = is.read(preamble, 0, 2);
            if (r != 2) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            throw new DSSException("Unable to read the 2 first bytes", (Throwable)e);
        }
        finally {
            Utils.closeQuietly((Closeable)is);
        }
        return preamble[0] == 80 && preamble[1] == 75;
    }

    public static boolean isXAdES(String entryName) {
        return ASiCUtils.isSignature(entryName) && entryName.endsWith(".xml");
    }

    public static boolean isCAdES(String entryName) {
        return ASiCUtils.isSignature(entryName) && entryName.endsWith(".p7s");
    }

    public static MimeType getMimeType(DSSDocument mimeTypeDocument) throws DSSException {
        InputStream is = null;
        try {
            is = mimeTypeDocument.openStream();
            byte[] byteArray = Utils.toByteArray((InputStream)is);
            String mimeTypeString = new String(byteArray, "UTF-8");
            MimeType mimeType = MimeType.fromMimeTypeString((String)mimeTypeString);
            return mimeType;
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
        finally {
            Utils.closeQuietly((Closeable)is);
        }
    }

    public static ASiCContainerType getContainerType(DSSDocument archive, DSSDocument mimetype, String zipComment, List<DSSDocument> signedDocuments) {
        ASiCContainerType containerType = ASiCUtils.getContainerTypeFromMimeType(archive.getMimeType());
        if (containerType == null && (containerType = ASiCUtils.getContainerTypeFromMimeTypeDocument(mimetype)) == null) {
            containerType = ASiCUtils.getContainerTypeFromZipComment(zipComment);
        }
        if (containerType == null) {
            LOG.warn("Unable to define the ASiC Container type with its properties");
            containerType = Utils.collectionSize(signedDocuments) <= 1 ? ASiCContainerType.ASiC_S : ASiCContainerType.ASiC_E;
        }
        return containerType;
    }

    private static ASiCContainerType getContainerTypeFromZipComment(String zipComment) {
        int indexOf;
        if (Utils.isStringNotBlank((String)zipComment) && (indexOf = zipComment.indexOf(MIME_TYPE_COMMENT)) > -1) {
            String asicCommentMimeTypeString = zipComment.substring(MIME_TYPE_COMMENT.length() + indexOf);
            MimeType mimeTypeFromZipComment = MimeType.fromMimeTypeString((String)asicCommentMimeTypeString);
            return ASiCUtils.getContainerTypeFromMimeType(mimeTypeFromZipComment);
        }
        return null;
    }

    private static ASiCContainerType getContainerTypeFromMimeTypeDocument(DSSDocument mimetype) {
        if (mimetype != null) {
            MimeType mimeTypeFromEmbeddedFile = ASiCUtils.getMimeType(mimetype);
            return ASiCUtils.getContainerTypeFromMimeType(mimeTypeFromEmbeddedFile);
        }
        return null;
    }

    private static ASiCContainerType getContainerTypeFromMimeType(MimeType mimeType) {
        if (ASiCUtils.isASiCMimeType(mimeType)) {
            return ASiCUtils.getASiCContainerType(mimeType);
        }
        return null;
    }
}

