/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.asic.ASiCExtractResult;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractASiCContainerExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractASiCContainerExtractor.class);
    private static final String MIME_TYPE = "mimetype";
    protected static final String META_INF_FOLDER = "META-INF/";
    private final DSSDocument asicContainer;

    protected AbstractASiCContainerExtractor(DSSDocument asicContainer) {
        this.asicContainer = asicContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASiCExtractResult extract() {
        ZipInputStream asicsInputStream;
        ASiCExtractResult result;
        block10: {
            result = new ASiCExtractResult();
            asicsInputStream = null;
            try {
                ZipEntry entry;
                asicsInputStream = new ZipInputStream(this.asicContainer.openStream());
                while ((entry = asicsInputStream.getNextEntry()) != null) {
                    String entryName = entry.getName();
                    if (this.isMetaInfFolder(entryName)) {
                        if (this.isAllowedSignature(entryName)) {
                            result.getSignatureDocuments().add(this.getCurrentDocument(entryName, asicsInputStream));
                            continue;
                        }
                        if (this.isAllowedManifest(entryName)) {
                            result.getManifestDocuments().add(this.getCurrentDocument(entryName, asicsInputStream));
                            continue;
                        }
                        if (this.isFolder(entryName)) continue;
                        result.getUnsupportedDocuments().add(this.getCurrentDocument(entryName, asicsInputStream));
                        continue;
                    }
                    if (!this.isFolder(entryName)) {
                        if (this.isMimetype(entryName)) {
                            result.setMimeTypeDocument(this.getCurrentDocument(entryName, asicsInputStream));
                            continue;
                        }
                        result.getSignedDocuments().add(this.getCurrentDocument(entryName, asicsInputStream));
                        continue;
                    }
                    result.getUnsupportedDocuments().add(this.getCurrentDocument(entryName, asicsInputStream));
                }
                if (!Utils.isCollectionNotEmpty(result.getUnsupportedDocuments())) break block10;
                LOG.warn("Unsupported files : " + result.getUnsupportedDocuments());
            }
            catch (IOException e) {
                try {
                    LOG.warn("Unable to parse the container " + e.getMessage());
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(asicsInputStream);
                    throw throwable;
                }
                Utils.closeQuietly((Closeable)asicsInputStream);
            }
        }
        Utils.closeQuietly((Closeable)asicsInputStream);
        result.setZipComment(this.getZipComment());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getZipComment() {
        InputStream is = null;
        try {
            is = this.asicContainer.openStream();
            byte[] buffer = Utils.toByteArray((InputStream)is);
            int len = buffer.length;
            byte[] magicDirEnd = new byte[]{80, 75, 5, 6};
            for (int ii = len - magicDirEnd.length - 22; ii >= 0; --ii) {
                boolean isMagicStart = true;
                for (int jj = 0; jj < magicDirEnd.length; ++jj) {
                    if (buffer[ii + jj] == magicDirEnd[jj]) continue;
                    isMagicStart = false;
                    break;
                }
                if (!isMagicStart) continue;
                int commentLen = buffer[ii + 20] + buffer[ii + 21] * 256;
                int realLen = len - ii - 22;
                if (commentLen != realLen) {
                    LOG.warn("WARNING! ZIP comment size mismatch: directory says len is " + commentLen + ", but file ends after " + realLen + " bytes!");
                }
                String string = new String(buffer, ii + 22, realLen);
                return string;
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to extract the ZIP comment : " + e.getMessage());
        }
        finally {
            Utils.closeQuietly((Closeable)is);
        }
        return null;
    }

    private boolean isMimetype(String entryName) {
        return MIME_TYPE.equals(entryName);
    }

    private boolean isMetaInfFolder(String entryName) {
        return entryName.startsWith(META_INF_FOLDER);
    }

    private boolean isFolder(String entryName) {
        return entryName.endsWith("/");
    }

    abstract boolean isAllowedManifest(String var1);

    abstract boolean isAllowedSignature(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DSSDocument getCurrentDocument(String filepath, ZipInputStream zis) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            Utils.copy((InputStream)zis, (OutputStream)baos);
            InMemoryDocument inMemoryDocument = new InMemoryDocument(baos.toByteArray(), filepath);
            return inMemoryDocument;
        }
        finally {
            Utils.closeQuietly((Closeable)baos);
        }
    }
}

