/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.signature;

import eu.europa.esig.dss.AbstractSerializableSignatureParameters;
import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUnsupportedOperationException;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.asic.ASiCExtractResult;
import eu.europa.esig.dss.asic.ASiCParameters;
import eu.europa.esig.dss.asic.ASiCUtils;
import eu.europa.esig.dss.asic.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.MultipleDocumentsSignatureService;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class AbstractASiCSignatureService<SP extends AbstractSignatureParameters>
extends AbstractSignatureService<SP>
implements MultipleDocumentsSignatureService<SP> {
    private static final long serialVersionUID = 243114076381526665L;
    private static final String ZIP_ENTRY_DETACHED_FILE = "detached-file";
    private static final String ZIP_ENTRY_MIMETYPE = "mimetype";
    private ASiCExtractResult archiveContent = new ASiCExtractResult();

    protected AbstractASiCSignatureService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    protected void assertCanBeSign(List<DSSDocument> documents, ASiCParameters asicParameters) {
        if (!this.canBeSigned(documents, asicParameters)) {
            throw new DSSUnsupportedOperationException("You only can sign an ASiC container by using the same type of container and of signature");
        }
    }

    abstract boolean canBeSigned(List<DSSDocument> var1, ASiCParameters var2);

    public ToBeSigned getDataToSign(DSSDocument toSignDocument, SP parameters) throws DSSException {
        return this.getDataToSign(Arrays.asList(toSignDocument), (AbstractSerializableSignatureParameters)parameters);
    }

    public DSSDocument signDocument(DSSDocument toSignDocument, SP parameters, SignatureValue signatureValue) throws DSSException {
        return this.signDocument(Arrays.asList(toSignDocument), (AbstractSerializableSignatureParameters)parameters, signatureValue);
    }

    protected void extractCurrentArchive(DSSDocument archive) {
        AbstractASiCContainerExtractor extractor = this.getArchiveExtractor(archive);
        this.archiveContent = extractor.extract();
    }

    abstract AbstractASiCContainerExtractor getArchiveExtractor(DSSDocument var1);

    protected List<DSSDocument> getEmbeddedSignatures() {
        return this.archiveContent.getSignatureDocuments();
    }

    protected List<DSSDocument> getEmbeddedManifests() {
        return this.archiveContent.getManifestDocuments();
    }

    protected List<DSSDocument> getEmbeddedSignedDocuments() {
        return this.archiveContent.getSignedDocuments();
    }

    protected DSSDocument getEmbeddedMimetype() {
        return this.archiveContent.getMimeTypeDocument();
    }

    protected void copyExistingArchiveWithSignatureList(DSSDocument archiveDocument, List<DSSDocument> signaturesToAdd, ByteArrayOutputStream baos) {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(baos);
            this.copyArchiveContentWithoutSignatures(archiveDocument, zos);
            this.storeSignatures(signaturesToAdd, zos);
        }
        catch (IOException e) {
            try {
                throw new DSSException("Unable to extend the ASiC container", (Throwable)e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(zos);
                throw throwable;
            }
        }
        Utils.closeQuietly((Closeable)zos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyArchiveContentWithoutSignatures(DSSDocument archiveDocument, ZipOutputStream zos) throws IOException {
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            zis = new ZipInputStream(archiveDocument.openStream());
            while ((entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                ZipEntry newEntry = new ZipEntry(name);
                if (this.isSignatureFilename(name)) continue;
                zos.putNextEntry(newEntry);
                Utils.copy((InputStream)zis, (OutputStream)zos);
            }
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(zis);
            throw throwable;
        }
        Utils.closeQuietly((Closeable)zis);
    }

    abstract boolean isSignatureFilename(String var1);

    protected DSSDocument buildASiCContainer(List<DSSDocument> documentsToBeSigned, List<DSSDocument> signatures, List<DSSDocument> manifestDocuments, ASiCParameters asicParameters) {
        ByteArrayOutputStream baos = null;
        ZipOutputStream zos = null;
        try {
            baos = new ByteArrayOutputStream();
            zos = new ZipOutputStream(baos);
            if (ASiCUtils.isASiCE(asicParameters)) {
                this.storeASICEManifest(manifestDocuments, zos);
            }
            this.storeSignatures(signatures, zos);
            this.storeSignedFiles(documentsToBeSigned, zos);
            this.storeMimetype(asicParameters, zos);
            this.storeZipComment(asicParameters, zos);
        }
        catch (IOException e) {
            try {
                throw new DSSException("Unable to build the ASiC Container", (Throwable)e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(zos);
                Utils.closeQuietly((Closeable)baos);
                throw throwable;
            }
        }
        Utils.closeQuietly((Closeable)zos);
        Utils.closeQuietly((Closeable)baos);
        return new InMemoryDocument(baos.toByteArray(), null, ASiCUtils.getMimeType(asicParameters));
    }

    private void storeASICEManifest(List<DSSDocument> manifestDocuments, ZipOutputStream zos) throws IOException {
        for (DSSDocument manifestDocument : manifestDocuments) {
            ZipEntry entrySignature = new ZipEntry(manifestDocument.getName());
            zos.putNextEntry(entrySignature);
            manifestDocument.writeTo((OutputStream)zos);
        }
    }

    abstract void storeSignatures(List<DSSDocument> var1, ZipOutputStream var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSignedFiles(List<DSSDocument> detachedDocuments, ZipOutputStream zos) throws IOException {
        for (DSSDocument detachedDocument : detachedDocuments) {
            InputStream is = null;
            try {
                String detachedDocumentName = detachedDocument.getName();
                String name = detachedDocumentName != null ? detachedDocumentName : ZIP_ENTRY_DETACHED_FILE;
                ZipEntry entryDocument = new ZipEntry(name);
                zos.setLevel(8);
                zos.putNextEntry(entryDocument);
                is = detachedDocument.openStream();
                Utils.copy((InputStream)is, (OutputStream)zos);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(is);
                throw throwable;
            }
            Utils.closeQuietly((Closeable)is);
        }
    }

    private void storeMimetype(ASiCParameters asicParameters, ZipOutputStream zos) throws IOException {
        byte[] mimeTypeBytes = ASiCUtils.getMimeTypeString(asicParameters).getBytes("UTF-8");
        ZipEntry entryMimetype = this.getZipEntryMimeType(mimeTypeBytes);
        zos.putNextEntry(entryMimetype);
        Utils.write((byte[])mimeTypeBytes, (OutputStream)zos);
    }

    private ZipEntry getZipEntryMimeType(byte[] mimeTypeBytes) {
        ZipEntry entryMimetype = new ZipEntry(ZIP_ENTRY_MIMETYPE);
        entryMimetype.setMethod(0);
        entryMimetype.setSize(mimeTypeBytes.length);
        entryMimetype.setCompressedSize(mimeTypeBytes.length);
        CRC32 crc = new CRC32();
        crc.update(mimeTypeBytes);
        entryMimetype.setCrc(crc.getValue());
        return entryMimetype;
    }

    protected void storeZipComment(ASiCParameters asicParameters, ZipOutputStream zos) {
        if (asicParameters.isZipComment()) {
            zos.setComment("mimetype=" + ASiCUtils.getMimeTypeString(asicParameters));
        }
    }
}

