/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.signature.asics;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class AbstractGetDataToSignASiCS {
    private static final String ZIP_ENTRY_DETACHED_FILE = "detached-file";

    protected DSSDocument createPackageZip(List<DSSDocument> documents, Date signingDate) {
        ByteArrayOutputStream baos = null;
        ZipOutputStream zos = null;
        try {
            baos = new ByteArrayOutputStream();
            zos = new ZipOutputStream(baos);
            for (DSSDocument document : documents) {
                String documentName = document.getName();
                String name = documentName != null ? documentName : ZIP_ENTRY_DETACHED_FILE;
                ZipEntry entryDocument = new ZipEntry(name);
                entryDocument.setTime(signingDate.getTime());
                entryDocument.setMethod(0);
                byte[] byteArray = DSSUtils.toByteArray((DSSDocument)document);
                entryDocument.setSize(byteArray.length);
                entryDocument.setCompressedSize(byteArray.length);
                CRC32 crc = new CRC32();
                crc.update(byteArray);
                entryDocument.setCrc(crc.getValue());
                zos.putNextEntry(entryDocument);
                Utils.write((byte[])byteArray, (OutputStream)zos);
            }
        }
        catch (IOException e) {
            try {
                throw new DSSException("Unable to create package.zip file", (Throwable)e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(zos);
                Utils.closeQuietly((Closeable)baos);
                throw throwable;
            }
        }
        Utils.closeQuietly((Closeable)zos);
        Utils.closeQuietly((Closeable)baos);
        return new InMemoryDocument(baos.toByteArray(), "package.zip");
    }
}

