/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.signature;

import eu.europa.esig.dss.BLevelParameters;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.asic.ASiCExtractResult;
import eu.europa.esig.dss.asic.ASiCParameters;
import eu.europa.esig.dss.asic.ASiCUtils;
import eu.europa.esig.dss.asic.ASiCWithXAdESContainerExtractor;
import eu.europa.esig.dss.asic.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.asic.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.asic.signature.asice.DataToSignASiCEWithXAdESFromArchive;
import eu.europa.esig.dss.asic.signature.asice.DataToSignASiCEWithXAdESFromFiles;
import eu.europa.esig.dss.asic.signature.asics.DataToSignASiCSWithXAdESFromArchive;
import eu.europa.esig.dss.asic.signature.asics.DataToSignASiCSWithXAdESFromFiles;
import java.util.List;

public class ASiCWithXAdESDataToSignHelperBuilder {
    private ASiCWithXAdESDataToSignHelperBuilder() {
    }

    public static GetDataToSignASiCWithXAdESHelper getGetDataToSignHelper(List<DSSDocument> documents, ASiCWithXAdESSignatureParameters parameters) {
        BLevelParameters bLevel = parameters.bLevel();
        boolean asice = ASiCUtils.isASiCE((ASiCParameters)parameters.aSiC());
        boolean archive = ASiCUtils.isArchive(documents);
        if (archive) {
            DSSDocument archiveDoc = documents.get(0);
            if (!ASiCUtils.isArchiveContainsCorrectSignatureExtension((DSSDocument)archiveDoc, (String)".xml")) {
                throw new UnsupportedOperationException("Container type doesn't match");
            }
            ASiCWithXAdESContainerExtractor extractor = new ASiCWithXAdESContainerExtractor(archiveDoc);
            ASiCExtractResult extract = extractor.extract();
            if (asice) {
                return new DataToSignASiCEWithXAdESFromArchive(extract.getSignedDocuments(), extract.getSignatureDocuments(), extract.getManifestDocuments(), parameters.aSiC());
            }
            return new DataToSignASiCSWithXAdESFromArchive(extract.getSignatureDocuments(), extract.getSignedDocuments(), parameters.aSiC());
        }
        if (asice) {
            return new DataToSignASiCEWithXAdESFromFiles(documents, parameters.aSiC());
        }
        return new DataToSignASiCSWithXAdESFromFiles(documents, bLevel.getSigningDate(), parameters.aSiC());
    }
}

