/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.signature;

import eu.europa.esig.dss.ASiCContainerType;
import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.SignaturePackaging;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.SigningOperation;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.asic.ASiCParameters;
import eu.europa.esig.dss.asic.ASiCUtils;
import eu.europa.esig.dss.asic.ASiCWithXAdESContainerExtractor;
import eu.europa.esig.dss.asic.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.asic.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.signature.ASiCWithXAdESDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.signature.AbstractASiCSignatureService;
import eu.europa.esig.dss.asic.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESService;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ASiCWithXAdESService
extends AbstractASiCSignatureService<ASiCWithXAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCWithXAdESService.class);

    public ASiCWithXAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ ASiCService with XAdES created");
    }

    public ToBeSigned getDataToSign(List<DSSDocument> toSignDocuments, ASiCWithXAdESSignatureParameters parameters) throws DSSException {
        ASiCParameters asicParameters = parameters.aSiC();
        this.assertCanBeSign(toSignDocuments, asicParameters);
        GetDataToSignASiCWithXAdESHelper dataToSignHelper = ASiCWithXAdESDataToSignHelperBuilder.getGetDataToSignHelper(toSignDocuments, parameters);
        XAdESSignatureParameters xadesParameters = this.getXAdESParameters(parameters, dataToSignHelper.getExistingSignature());
        return this.getXAdESService().getDataToSign(dataToSignHelper.getToBeSigned(), xadesParameters);
    }

    public DSSDocument signDocument(List<DSSDocument> toSignDocuments, ASiCWithXAdESSignatureParameters parameters, SignatureValue signatureValue) throws DSSException {
        ASiCParameters asicParameters = parameters.aSiC();
        this.assertCanBeSign(toSignDocuments, asicParameters);
        this.assertSigningDateInCertificateValidityRange((AbstractSignatureParameters)parameters);
        GetDataToSignASiCWithXAdESHelper dataToSignHelper = ASiCWithXAdESDataToSignHelperBuilder.getGetDataToSignHelper(toSignDocuments, parameters);
        List signatures = dataToSignHelper.getSignatures();
        List manifestFiles = dataToSignHelper.getManifestFiles();
        List signedDocuments = dataToSignHelper.getSignedDocuments();
        XAdESSignatureParameters xadesParameters = this.getXAdESParameters(parameters, dataToSignHelper.getExistingSignature());
        DSSDocument newSignature = this.getXAdESService().signDocument(dataToSignHelper.getToBeSigned(), xadesParameters, signatureValue);
        String newSignatureFilename = dataToSignHelper.getSignatureFilename();
        newSignature.setName(newSignatureFilename);
        if (ASiCUtils.isASiCS((ASiCParameters)asicParameters)) {
            Iterator iterator = signatures.iterator();
            while (iterator.hasNext()) {
                if (!Utils.areStringsEqual((String)newSignatureFilename, (String)((DSSDocument)iterator.next()).getName())) continue;
                iterator.remove();
            }
        }
        signatures.add(newSignature);
        DSSDocument asicSignature = this.buildASiCContainer(signedDocuments, signatures, manifestFiles, asicParameters);
        asicSignature.setName(DSSUtils.getFinalFileName((DSSDocument)asicSignature, (SigningOperation)SigningOperation.SIGN, (SignatureLevel)parameters.getSignatureLevel(), (ASiCContainerType)parameters.aSiC().getContainerType()));
        parameters.reinitDeterministicId();
        return asicSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSSDocument extendDocument(DSSDocument toExtendDocument, ASiCWithXAdESSignatureParameters parameters) throws DSSException {
        if (!ASiCUtils.isASiCContainer((DSSDocument)toExtendDocument) || !ASiCUtils.isArchiveContainsCorrectSignatureExtension((DSSDocument)toExtendDocument, (String)".xml")) {
            throw new DSSException("Unsupported file type");
        }
        this.extractCurrentArchive(toExtendDocument);
        List signedDocuments = this.getEmbeddedSignedDocuments();
        List signatureDocuments = this.getEmbeddedSignatures();
        ArrayList<DSSDocument> extendedDocuments = new ArrayList<DSSDocument>();
        for (DSSDocument signature : signatureDocuments) {
            XAdESSignatureParameters xadesParameters = this.getXAdESParameters(parameters, null);
            xadesParameters.setDetachedContents(signedDocuments);
            DSSDocument extendDocument = this.getXAdESService().extendDocument(signature, xadesParameters);
            extendedDocuments.add(extendDocument);
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            this.copyExistingArchiveWithSignatureList(toExtendDocument, extendedDocuments, baos);
        }
        finally {
            Utils.closeQuietly((Closeable)baos);
        }
        InMemoryDocument asicSignature = new InMemoryDocument(baos.toByteArray(), null, toExtendDocument.getMimeType());
        asicSignature.setName(DSSUtils.getFinalFileName((DSSDocument)toExtendDocument, (SigningOperation)SigningOperation.EXTEND, (SignatureLevel)parameters.getSignatureLevel(), (ASiCContainerType)parameters.aSiC().getContainerType()));
        return asicSignature;
    }

    void storeSignatures(List<DSSDocument> signatures, ZipOutputStream zos) throws IOException {
        for (DSSDocument dssDocument : signatures) {
            ZipEntry entrySignature = new ZipEntry(dssDocument.getName());
            zos.putNextEntry(entrySignature);
            Document xmlSignatureDoc = DomUtils.buildDOM((DSSDocument)dssDocument);
            DomUtils.writeDocumentTo((Document)xmlSignatureDoc, (OutputStream)zos);
        }
    }

    boolean isSignatureFilename(String name) {
        return ASiCUtils.isXAdES((String)name);
    }

    private XAdESService getXAdESService() {
        XAdESService xadesService = new XAdESService(this.certificateVerifier);
        xadesService.setTspSource(this.tspSource);
        return xadesService;
    }

    private XAdESSignatureParameters getXAdESParameters(ASiCWithXAdESSignatureParameters parameters, DSSDocument existingXAdESSignatureASiCS) {
        ASiCWithXAdESSignatureParameters xadesParameters = parameters;
        xadesParameters.setSignaturePackaging(SignaturePackaging.DETACHED);
        Document rootDocument = null;
        rootDocument = existingXAdESSignatureASiCS != null ? DomUtils.buildDOM((DSSDocument)existingXAdESSignatureASiCS) : DomUtils.createDocument((String)"http://uri.etsi.org/02918/v1.2.1#", (String)"asic:XAdESSignatures");
        xadesParameters.setRootDocument(rootDocument);
        return xadesParameters;
    }

    AbstractASiCContainerExtractor getArchiveExtractor(DSSDocument archive) {
        return new ASiCWithXAdESContainerExtractor(archive);
    }

    boolean canBeSigned(List<DSSDocument> documents, ASiCParameters asicParameters) {
        String mimeTypeFromParameter;
        DSSDocument archive;
        String expectedMimeType;
        boolean isMimetypeCorrect = true;
        boolean isSignatureTypeCorrect = true;
        if (ASiCUtils.isArchive(documents) && (isMimetypeCorrect = Utils.areStringsEqualIgnoreCase((String)(expectedMimeType = (archive = documents.get(0)).getMimeType().getMimeTypeString()), (String)(mimeTypeFromParameter = ASiCUtils.getMimeTypeString((ASiCParameters)asicParameters))))) {
            isSignatureTypeCorrect = ASiCUtils.isArchiveContainsCorrectSignatureExtension((DSSDocument)archive, (String)".xml");
        }
        return isMimetypeCorrect && isSignatureTypeCorrect;
    }

    static {
        DomUtils.registerNamespace((String)"asic", (String)"http://uri.etsi.org/02918/v1.2.1#");
    }
}

