/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.signature.asice;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.MimeType;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCEWithXAdESManifestBuilder {
    private final List<DSSDocument> documents;

    public ASiCEWithXAdESManifestBuilder(List<DSSDocument> documents) {
        this.documents = documents;
    }

    public Document build() {
        Document documentDom = DomUtils.buildDOM();
        Element manifestDom = documentDom.createElementNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:manifest");
        manifestDom.setAttribute("manifest:version", "1.2");
        documentDom.appendChild(manifestDom);
        Element rootDom = DomUtils.addElement((Document)documentDom, (Element)manifestDom, (String)"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", (String)"manifest:file-entry");
        rootDom.setAttribute("manifest:full-path", "/");
        rootDom.setAttribute("manifest:media-type", MimeType.ASICE.getMimeTypeString());
        for (DSSDocument document : this.documents) {
            Element fileDom = DomUtils.addElement((Document)documentDom, (Element)manifestDom, (String)"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", (String)"manifest:file-entry");
            fileDom.setAttribute("manifest:full-path", document.getName());
            fileDom.setAttribute("manifest:media-type", document.getMimeType().getMimeTypeString());
        }
        return documentDom;
    }
}

