/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.asic.ASiCUtils;
import eu.europa.esig.dss.asic.ASiCWithXAdESContainerExtractor;
import eu.europa.esig.dss.asic.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.validation.ASiCEWithXAdESManifestParser;
import eu.europa.esig.dss.asic.validation.AbstractASiCContainerValidator;
import eu.europa.esig.dss.asic.validation.XMLDocumentForASiCValidator;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestFile;
import java.util.ArrayList;
import java.util.List;

public class ASiCContainerWithXAdESValidator
extends AbstractASiCContainerValidator {
    private ASiCContainerWithXAdESValidator() {
        super(null);
    }

    public ASiCContainerWithXAdESValidator(DSSDocument asicContainer) {
        super(asicContainer);
        this.analyseEntries();
    }

    public boolean isSupported(DSSDocument dssDocument) {
        return ASiCUtils.isASiCContainer((DSSDocument)dssDocument) && ASiCUtils.isArchiveContainsCorrectSignatureExtension((DSSDocument)dssDocument, (String)".xml");
    }

    AbstractASiCContainerExtractor getArchiveExtractor() {
        return new ASiCWithXAdESContainerExtractor(this.document);
    }

    List<DocumentValidator> getValidators() {
        if (this.validators == null) {
            this.validators = new ArrayList();
            for (DSSDocument signature : this.getSignatureDocuments()) {
                XMLDocumentForASiCValidator xadesValidator = new XMLDocumentForASiCValidator(signature);
                xadesValidator.setCertificateVerifier(this.certificateVerifier);
                xadesValidator.setProcessExecutor(this.processExecutor);
                xadesValidator.setValidationCertPool(this.validationCertPool);
                xadesValidator.setSignaturePolicyProvider(this.signaturePolicyProvider);
                xadesValidator.setDetachedContents(this.getSignedDocuments());
                this.validators.add(xadesValidator);
            }
        }
        return this.validators;
    }

    protected List<ManifestFile> getManifestFilesDecriptions() {
        ArrayList<ManifestFile> descriptions = new ArrayList<ManifestFile>();
        List signatureDocuments = this.getSignatureDocuments();
        List manifestDocuments = this.getManifestDocuments();
        for (DSSDocument signatureDoc : signatureDocuments) {
            for (DSSDocument manifestDoc : manifestDocuments) {
                ASiCEWithXAdESManifestParser manifestParser = new ASiCEWithXAdESManifestParser(signatureDoc, manifestDoc);
                descriptions.add(manifestParser.getDescription());
            }
        }
        return descriptions;
    }
}

