/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ManifestFile;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ASiCEWithXAdESManifestParser {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCEWithXAdESManifestParser.class);
    private final DSSDocument signatureDocument;
    private final DSSDocument manifestDocument;

    public ASiCEWithXAdESManifestParser(DSSDocument signatureDocument, DSSDocument manifestDocument) {
        this.signatureDocument = signatureDocument;
        this.manifestDocument = manifestDocument;
    }

    public ManifestFile getDescription() {
        ManifestFile description = new ManifestFile();
        description.setSignatureFilename(this.signatureDocument.getName());
        description.setFilename(this.manifestDocument.getName());
        description.setEntries(this.getEntries());
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getEntries() {
        ArrayList<String> result = new ArrayList<String>();
        InputStream is = null;
        try {
            is = this.manifestDocument.openStream();
            Document manifestDom = DomUtils.buildDOM((InputStream)is);
            NodeList nodeList = DomUtils.getNodeList((Node)manifestDom, (String)"/manifest:manifest/manifest:file-entry");
            if (nodeList != null && nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element fileEntryElement = (Element)nodeList.item(i);
                    String fullpathValue = fileEntryElement.getAttribute("manifest:full-path");
                    if (this.isFolder(fullpathValue)) continue;
                    result.add(fullpathValue);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Unable to parse manifest file " + this.manifestDocument.getName(), (Throwable)e);
        }
        finally {
            Utils.closeQuietly((Closeable)is);
        }
        return result;
    }

    private boolean isFolder(String fullpathValue) {
        return fullpathValue.endsWith("/");
    }

    static {
        DomUtils.registerNamespace((String)"manifest", (String)"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0");
    }
}

