/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxArray;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfBoxDict
implements PdfDict {
    private static final Logger LOG = LoggerFactory.getLogger(PdfBoxDict.class);
    private COSDictionary wrapped;
    private PDDocument document;

    public PdfBoxDict(COSDictionary wrapped, PDDocument document) {
        Objects.requireNonNull(wrapped, "Pdf dictionary shall be provided!");
        Objects.requireNonNull(document, "Pdf document shall be provided!");
        this.wrapped = wrapped;
        this.document = document;
    }

    public PdfDict getAsDict(String name) {
        COSDictionary cosDictionary;
        COSBase cosBaseObject = this.wrapped.getDictionaryObject(name);
        if (cosBaseObject == null) {
            return null;
        }
        if (cosBaseObject instanceof COSDictionary) {
            cosDictionary = (COSDictionary)cosBaseObject;
        } else if (cosBaseObject instanceof COSObject) {
            COSObject cosObject = (COSObject)cosBaseObject;
            cosDictionary = (COSDictionary)cosObject.getObject();
        } else {
            LOG.warn("Unable to extract entry with name '{}' as dictionary!", (Object)name);
            return null;
        }
        return new PdfBoxDict(cosDictionary, this.document);
    }

    public PdfArray getAsArray(String name) {
        COSBase val = this.wrapped.getDictionaryObject(name);
        if (val instanceof COSArray) {
            return new PdfBoxArray((COSArray)val, this.document);
        }
        return null;
    }

    public byte[] getBinariesValue(String name) throws IOException {
        COSBase val = this.wrapped.getDictionaryObject(name);
        if (val instanceof COSString) {
            return ((COSString)val).getBytes();
        }
        throw new IOException(name + " was expected to be a COSString element but was : " + val);
    }

    public String[] list() {
        Set cosNames = this.wrapped.keySet();
        ArrayList<String> result = new ArrayList<String>(cosNames.size());
        for (COSName cosName : cosNames) {
            String name = cosName.getName();
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getStringValue(String name) {
        return this.wrapped.getString(name);
    }

    public String getNameValue(String name) {
        return this.wrapped.getNameAsString(name);
    }

    public Date getDateValue(String name) {
        Calendar cal = this.wrapped.getDate(name);
        if (cal != null) {
            return cal.getTime();
        }
        return null;
    }

    public Number getNumberValue(String name) {
        COSBase val = this.wrapped.getDictionaryObject(name);
        if (val != null) {
            if (val instanceof COSFloat) {
                return Float.valueOf(((COSFloat)val).floatValue());
            }
            if (val instanceof COSNumber) {
                return ((COSNumber)val).longValue();
            }
        }
        return null;
    }

    public Object getObject(String name) {
        COSBase dictionaryObject = this.wrapped.getDictionaryObject(name);
        if (dictionaryObject == null) {
            return null;
        }
        if (dictionaryObject instanceof COSDictionary || dictionaryObject instanceof COSObject) {
            return this.getAsDict(name);
        }
        if (dictionaryObject instanceof COSArray) {
            return this.getAsArray(name);
        }
        if (dictionaryObject instanceof COSString) {
            return this.getStringValue(name);
        }
        if (dictionaryObject instanceof COSName) {
            return this.getNameValue(name);
        }
        if (dictionaryObject instanceof COSNumber) {
            return this.getNumberValue(name);
        }
        if (dictionaryObject instanceof COSBoolean) {
            return ((COSBoolean)dictionaryObject).getValueAsObject();
        }
        if (dictionaryObject instanceof COSNull) {
            return null;
        }
        LOG.warn("Unable to process an entry with name '{}' of type '{}'.", (Object)name, dictionaryObject.getClass());
        return null;
    }

    public Long getObjectNumber(String name) {
        COSBase dictionaryObject = this.wrapped.getItem(name);
        if (dictionaryObject instanceof COSObject) {
            return ((COSObject)dictionaryObject).getObjectNumber();
        }
        return null;
    }

    public byte[] getStreamBytes() throws IOException {
        if (this.wrapped instanceof COSStream) {
            try (COSInputStream is = ((COSStream)this.wrapped).createInputStream();){
                byte[] byArray = Utils.toByteArray((InputStream)is);
                return byArray;
            }
        }
        return null;
    }

    public InputStream createRawInputStream() throws IOException {
        if (this.wrapped instanceof COSStream) {
            return ((COSStream)this.wrapped).createRawInputStream();
        }
        return null;
    }

    public long getRawStreamSize() throws IOException {
        try (InputStream is = this.createRawInputStream();){
            if (is != null) {
                long l = Utils.getInputStreamSize((InputStream)is);
                return l;
            }
        }
        return -1L;
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

