/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature;

import eu.europa.esig.dss.ASiCContainerType;
import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.RemoteCertificate;
import eu.europa.esig.dss.RemoteDocument;
import eu.europa.esig.dss.RemoteSignatureParameters;
import eu.europa.esig.dss.SignatureForm;
import eu.europa.esig.dss.asic.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class AbstractRemoteSignatureServiceImpl {
    protected AbstractSignatureParameters getASiCSignatureParameters(AbstractSignatureParameters parameters, ASiCContainerType asicContainerType, SignatureForm signatureForm) {
        switch (signatureForm) {
            case CAdES: {
                ASiCWithCAdESSignatureParameters asicWithCAdESParameters = new ASiCWithCAdESSignatureParameters();
                asicWithCAdESParameters.aSiC().setContainerType(asicContainerType);
                parameters = asicWithCAdESParameters;
                break;
            }
            case XAdES: {
                ASiCWithXAdESSignatureParameters asicWithXAdESParameters = new ASiCWithXAdESSignatureParameters();
                asicWithXAdESParameters.aSiC().setContainerType(asicContainerType);
                parameters = asicWithXAdESParameters;
                break;
            }
            default: {
                throw new DSSException("Unrecognized format (XAdES or CAdES are allowed with ASiC) : " + signatureForm);
            }
        }
        return parameters;
    }

    protected AbstractSignatureParameters createParameters(RemoteSignatureParameters remoteParameters) {
        AbstractSignatureParameters parameters = null;
        ASiCContainerType asicContainerType = remoteParameters.getAsicContainerType();
        SignatureForm signatureForm = remoteParameters.getSignatureLevel().getSignatureForm();
        if (asicContainerType != null) {
            parameters = this.getASiCSignatureParameters(parameters, asicContainerType, signatureForm);
        } else {
            switch (signatureForm) {
                case CAdES: {
                    parameters = new CAdESSignatureParameters();
                    break;
                }
                case PAdES: {
                    PAdESSignatureParameters padesParams = new PAdESSignatureParameters();
                    padesParams.setSignatureSize(18944);
                    parameters = padesParams;
                    break;
                }
                case XAdES: {
                    parameters = new XAdESSignatureParameters();
                    break;
                }
                default: {
                    throw new DSSException("Unsupported signature form : " + signatureForm);
                }
            }
        }
        this.fillParameters(parameters, remoteParameters);
        return parameters;
    }

    protected void fillParameters(AbstractSignatureParameters parameters, RemoteSignatureParameters remoteParameters) {
        List remoteCertificateChain;
        parameters.setBLevelParams(remoteParameters.bLevel());
        parameters.setDetachedContents(this.createDSSDocuments(remoteParameters.getDetachedContents()));
        parameters.setDigestAlgorithm(remoteParameters.getDigestAlgorithm());
        parameters.setEncryptionAlgorithm(remoteParameters.getEncryptionAlgorithm());
        parameters.setSignatureLevel(remoteParameters.getSignatureLevel());
        parameters.setSignaturePackaging(remoteParameters.getSignaturePackaging());
        parameters.setSignatureTimestampParameters(remoteParameters.getSignatureTimestampParameters());
        parameters.setArchiveTimestampParameters(remoteParameters.getArchiveTimestampParameters());
        parameters.setContentTimestampParameters(remoteParameters.getContentTimestampParameters());
        parameters.setSignWithExpiredCertificate(remoteParameters.isSignWithExpiredCertificate());
        RemoteCertificate signingCertificate = remoteParameters.getSigningCertificate();
        if (signingCertificate != null) {
            CertificateToken loadCertificate = DSSUtils.loadCertificate((byte[])signingCertificate.getEncodedCertificate());
            parameters.setSigningCertificate(loadCertificate);
        }
        if (Utils.isCollectionNotEmpty((Collection)(remoteCertificateChain = remoteParameters.getCertificateChain()))) {
            LinkedList<CertificateToken> certificateChain = new LinkedList<CertificateToken>();
            for (RemoteCertificate remoteCertificate : remoteCertificateChain) {
                certificateChain.add(DSSUtils.loadCertificate((byte[])remoteCertificate.getEncodedCertificate()));
            }
            parameters.setCertificateChain(certificateChain);
        }
    }

    protected List<DSSDocument> createDSSDocuments(List<RemoteDocument> remoteDocuments) {
        if (Utils.isCollectionNotEmpty(remoteDocuments)) {
            ArrayList<DSSDocument> dssDocuments = new ArrayList<DSSDocument>();
            for (RemoteDocument remoteDocument : remoteDocuments) {
                dssDocuments.add((DSSDocument)this.createDSSDocument(remoteDocument));
            }
            return dssDocuments;
        }
        return null;
    }

    protected InMemoryDocument createDSSDocument(RemoteDocument remoteDocument) {
        if (remoteDocument != null) {
            InMemoryDocument dssDocument = new InMemoryDocument(remoteDocument.getBytes());
            dssDocument.setMimeType(remoteDocument.getMimeType());
            dssDocument.setAbsolutePath(remoteDocument.getAbsolutePath());
            dssDocument.setName(remoteDocument.getName());
            return dssDocument;
        }
        return null;
    }
}

