/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature;

import eu.europa.esig.dss.ASiCContainerType;
import eu.europa.esig.dss.AbstractSerializableSignatureParameters;
import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.RemoteDocument;
import eu.europa.esig.dss.RemoteSignatureParameters;
import eu.europa.esig.dss.SignatureForm;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.asic.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.signature.AbstractRemoteSignatureServiceImpl;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import eu.europa.esig.dss.signature.RemoteDocumentSignatureService;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDocumentSignatureServiceImpl
extends AbstractRemoteSignatureServiceImpl
implements RemoteDocumentSignatureService<RemoteDocument, RemoteSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteDocumentSignatureServiceImpl.class);
    private DocumentSignatureService<XAdESSignatureParameters> xadesService;
    private DocumentSignatureService<CAdESSignatureParameters> cadesService;
    private DocumentSignatureService<PAdESSignatureParameters> padesService;
    private DocumentSignatureService<ASiCWithXAdESSignatureParameters> asicWithXAdESService;
    private DocumentSignatureService<ASiCWithCAdESSignatureParameters> asicWithCAdESService;

    public void setXadesService(DocumentSignatureService<XAdESSignatureParameters> xadesService) {
        this.xadesService = xadesService;
    }

    public void setCadesService(DocumentSignatureService<CAdESSignatureParameters> cadesService) {
        this.cadesService = cadesService;
    }

    public void setPadesService(DocumentSignatureService<PAdESSignatureParameters> padesService) {
        this.padesService = padesService;
    }

    public void setAsicWithXAdESService(DocumentSignatureService<ASiCWithXAdESSignatureParameters> asicWithXAdESService) {
        this.asicWithXAdESService = asicWithXAdESService;
    }

    public void setAsicWithCAdESService(DocumentSignatureService<ASiCWithCAdESSignatureParameters> asicWithCAdESService) {
        this.asicWithCAdESService = asicWithCAdESService;
    }

    private DocumentSignatureService getServiceForSignature(RemoteSignatureParameters parameters) {
        ASiCContainerType asicContainerType = parameters.getAsicContainerType();
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        SignatureForm signatureForm = signatureLevel.getSignatureForm();
        if (asicContainerType != null) {
            switch (signatureForm) {
                case XAdES: {
                    return this.asicWithXAdESService;
                }
                case CAdES: {
                    return this.asicWithCAdESService;
                }
            }
            throw new DSSException("Unrecognized format (XAdES or CAdES are allowed with ASiC) : " + signatureForm);
        }
        switch (signatureForm) {
            case XAdES: {
                return this.xadesService;
            }
            case CAdES: {
                return this.cadesService;
            }
            case PAdES: {
                return this.padesService;
            }
        }
        throw new DSSException("Unrecognized format " + signatureLevel);
    }

    public ToBeSigned getDataToSign(RemoteDocument remoteDocument, RemoteSignatureParameters remoteParameters) throws DSSException {
        LOG.info("GetDataToSign in process...");
        AbstractSignatureParameters parameters = this.createParameters(remoteParameters);
        DocumentSignatureService service = this.getServiceForSignature(remoteParameters);
        InMemoryDocument dssDocument = this.createDSSDocument(remoteDocument);
        ToBeSigned dataToSign = service.getDataToSign((Object)dssDocument, (AbstractSerializableSignatureParameters)parameters);
        LOG.info("GetDataToSign is finished");
        return dataToSign;
    }

    public DSSDocument signDocument(RemoteDocument remoteDocument, RemoteSignatureParameters remoteParameters, SignatureValue signatureValue) throws DSSException {
        LOG.info("SignDocument in process...");
        AbstractSignatureParameters parameters = this.createParameters(remoteParameters);
        DocumentSignatureService service = this.getServiceForSignature(remoteParameters);
        InMemoryDocument dssDocument = this.createDSSDocument(remoteDocument);
        DSSDocument signDocument = service.signDocument((Object)dssDocument, (AbstractSerializableSignatureParameters)parameters, signatureValue);
        LOG.info("SignDocument is finished");
        return signDocument;
    }

    public DSSDocument extendDocument(RemoteDocument remoteDocument, RemoteSignatureParameters remoteParameters) throws DSSException {
        LOG.info("ExtendDocument in process...");
        AbstractSignatureParameters parameters = this.createParameters(remoteParameters);
        DocumentSignatureService service = this.getServiceForSignature(remoteParameters);
        InMemoryDocument dssDocument = this.createDSSDocument(remoteDocument);
        DSSDocument extendDocument = service.extendDocument((Object)dssDocument, (AbstractSerializableSignatureParameters)parameters);
        LOG.info("ExtendDocument is finished");
        return extendDocument;
    }
}

