/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature;

import eu.europa.esig.dss.ASiCContainerType;
import eu.europa.esig.dss.AbstractSerializableSignatureParameters;
import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.RemoteDocument;
import eu.europa.esig.dss.RemoteSignatureParameters;
import eu.europa.esig.dss.SignatureForm;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.asic.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.signature.AbstractRemoteSignatureServiceImpl;
import eu.europa.esig.dss.signature.MultipleDocumentsSignatureService;
import eu.europa.esig.dss.signature.RemoteMultipleDocumentsSignatureService;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteMultipleDocumentsSignatureServiceImpl
extends AbstractRemoteSignatureServiceImpl
implements RemoteMultipleDocumentsSignatureService<RemoteDocument, RemoteSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteMultipleDocumentsSignatureServiceImpl.class);
    private MultipleDocumentsSignatureService<XAdESSignatureParameters> xadesService;
    private MultipleDocumentsSignatureService<ASiCWithCAdESSignatureParameters> asicWithCAdESService;
    private MultipleDocumentsSignatureService<ASiCWithXAdESSignatureParameters> asicWithXAdESService;

    public void setXadesService(MultipleDocumentsSignatureService<XAdESSignatureParameters> xadesService) {
        this.xadesService = xadesService;
    }

    public void setAsicWithCAdESService(MultipleDocumentsSignatureService<ASiCWithCAdESSignatureParameters> asicWithCAdESService) {
        this.asicWithCAdESService = asicWithCAdESService;
    }

    public void setAsicWithXAdESService(MultipleDocumentsSignatureService<ASiCWithXAdESSignatureParameters> asicWithXAdESService) {
        this.asicWithXAdESService = asicWithXAdESService;
    }

    public ToBeSigned getDataToSign(List<RemoteDocument> toSignDocuments, RemoteSignatureParameters remoteParameters) throws DSSException {
        LOG.info("GetDataToSign in process...");
        AbstractSignatureParameters parameters = this.createParameters(remoteParameters);
        MultipleDocumentsSignatureService service = this.getServiceForSignature(remoteParameters);
        List<DSSDocument> dssDocuments = this.createDSSDocuments(toSignDocuments);
        ToBeSigned dataToSign = service.getDataToSign(dssDocuments, (AbstractSerializableSignatureParameters)parameters);
        LOG.info("GetDataToSign is finished");
        return dataToSign;
    }

    public DSSDocument signDocument(List<RemoteDocument> toSignDocuments, RemoteSignatureParameters remoteParameters, SignatureValue signatureValue) throws DSSException {
        LOG.info("SignDocument in process...");
        AbstractSignatureParameters parameters = this.createParameters(remoteParameters);
        MultipleDocumentsSignatureService service = this.getServiceForSignature(remoteParameters);
        List<DSSDocument> dssDocuments = this.createDSSDocuments(toSignDocuments);
        DSSDocument signDocument = service.signDocument(dssDocuments, (AbstractSerializableSignatureParameters)parameters, signatureValue);
        LOG.info("SignDocument is finished");
        return signDocument;
    }

    public DSSDocument extendDocument(RemoteDocument toExtendDocument, RemoteSignatureParameters remoteParameters) throws DSSException {
        LOG.info("ExtendDocument in process...");
        AbstractSignatureParameters parameters = this.createParameters(remoteParameters);
        MultipleDocumentsSignatureService service = this.getServiceForSignature(remoteParameters);
        InMemoryDocument dssDocument = this.createDSSDocument(toExtendDocument);
        DSSDocument extendDocument = service.extendDocument((Object)dssDocument, (AbstractSerializableSignatureParameters)parameters);
        LOG.info("ExtendDocument is finished");
        return extendDocument;
    }

    private MultipleDocumentsSignatureService getServiceForSignature(RemoteSignatureParameters parameters) {
        ASiCContainerType asicContainerType = parameters.getAsicContainerType();
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        SignatureForm signatureForm = signatureLevel.getSignatureForm();
        if (asicContainerType != null) {
            switch (signatureForm) {
                case XAdES: {
                    return this.asicWithXAdESService;
                }
                case CAdES: {
                    return this.asicWithCAdESService;
                }
            }
            throw new DSSException("Unrecognized format (XAdES or CAdES are allowed with ASiC) : " + signatureForm);
        }
        if (SignatureForm.XAdES == signatureForm) {
            return this.xadesService;
        }
        throw new DSSException("Unrecognized format (XAdES or CAdES are allowed with ASiC or XAdES) : " + signatureForm);
    }
}

