/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.RemoteDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.dss.validation.reports.dto.ReportsDTO;
import eu.europa.esig.jaxb.policy.ConstraintsParameters;
import java.util.ArrayList;

public class RemoteDocumentValidationService {
    private CertificateVerifier verifier;

    public void setVerifier(CertificateVerifier verifier) {
        this.verifier = verifier;
    }

    public ReportsDTO validateDocument(RemoteDocument signedFile, RemoteDocument originalFile, ConstraintsParameters policy) {
        InMemoryDocument signedDocument = new InMemoryDocument(signedFile.getBytes(), signedFile.getName(), signedFile.getMimeType());
        SignedDocumentValidator signedDocValidator = SignedDocumentValidator.fromDocument((DSSDocument)signedDocument);
        signedDocValidator.setCertificateVerifier(this.verifier);
        if (originalFile != null && Utils.isArrayNotEmpty((byte[])originalFile.getBytes())) {
            ArrayList<InMemoryDocument> list = new ArrayList<InMemoryDocument>();
            InMemoryDocument orignalDocument = new InMemoryDocument(originalFile.getBytes(), originalFile.getName(), originalFile.getMimeType());
            list.add(orignalDocument);
            signedDocValidator.setDetachedContents(list);
        }
        Reports reports = policy != null ? signedDocValidator.validateDocument(policy) : signedDocValidator.validateDocument();
        ReportsDTO result = new ReportsDTO(reports.getDiagnosticDataJaxb(), reports.getSimpleReportJaxb(), reports.getDetailedReportJaxb());
        return result;
    }
}

