/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.service;

import eu.europa.esig.dss.tsl.TSLParserResult;
import eu.europa.esig.dss.tsl.TSLPointer;
import eu.europa.esig.dss.tsl.TSLService;
import eu.europa.esig.dss.tsl.TSLServiceProvider;
import eu.europa.esig.dss.tsl.TSLServiceStatusAndInformationExtensions;
import eu.europa.esig.dss.tsl.service.TSLParser;
import eu.europa.esig.dss.util.TimeDependentValues;
import eu.europa.esig.dss.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TSLSParserTest {
    private static final List<String> countriesWithoutTSP = new ArrayList<String>();
    private File fileToTest;

    @Parameterized.Parameters(name="TSL to parse {index} : {0}")
    public static Collection<Object[]> data() {
        File folder = new File("src/test/resources/tsls");
        Collection listFiles = Utils.listFiles((File)folder, (String[])new String[]{"xml"}, (boolean)true);
        ArrayList<Object[]> dataToRun = new ArrayList<Object[]>();
        for (File file : listFiles) {
            dataToRun.add(new Object[]{file});
        }
        return dataToRun;
    }

    public TSLSParserTest(File fileToTest) {
        this.fileToTest = fileToTest;
    }

    @Test
    public void parseTSL() throws Exception {
        TSLParser parser = new TSLParser((InputStream)new FileInputStream(this.fileToTest));
        TSLParserResult result = parser.call();
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getNextUpdateDate());
        Assert.assertNotNull((Object)result.getIssueDate());
        Assert.assertTrue((boolean)Utils.isStringNotEmpty((String)result.getTerritory()));
        Assert.assertTrue((result.getSequenceNumber() > 0 ? 1 : 0) != 0);
        List pointers = result.getPointers();
        Assert.assertTrue((boolean)Utils.isCollectionNotEmpty((Collection)pointers));
        for (TSLPointer tslPointer : pointers) {
            Assert.assertTrue((boolean)Utils.isStringNotEmpty((String)tslPointer.getMimeType()));
            Assert.assertTrue((boolean)Utils.isStringNotEmpty((String)tslPointer.getTerritory()));
            Assert.assertTrue((boolean)Utils.isStringNotEmpty((String)tslPointer.getUrl()));
            Assert.assertTrue((boolean)Utils.isCollectionNotEmpty((Collection)tslPointer.getPotentialSigners()));
        }
        List serviceProviders = result.getServiceProviders();
        if (countriesWithoutTSP.contains(result.getTerritory())) {
            Assert.assertTrue((boolean)Utils.isCollectionEmpty((Collection)serviceProviders));
        } else {
            Assert.assertTrue((boolean)Utils.isCollectionNotEmpty((Collection)serviceProviders));
            for (TSLServiceProvider tslServiceProvider : serviceProviders) {
                Assert.assertTrue((boolean)Utils.isStringNotEmpty((String)tslServiceProvider.getName()));
                Assert.assertTrue((boolean)Utils.isStringNotEmpty((String)tslServiceProvider.getPostalAddress()));
                Assert.assertTrue((boolean)Utils.isStringNotEmpty((String)tslServiceProvider.getElectronicAddress()));
                List services = tslServiceProvider.getServices();
                Assert.assertTrue((boolean)Utils.isCollectionNotEmpty((Collection)services));
                for (TSLService tslService : services) {
                    Assert.assertTrue((boolean)Utils.isStringNotEmpty((String)tslService.getName()));
                    TimeDependentValues status = tslService.getStatusAndInformationExtensions();
                    int n = 0;
                    for (TSLServiceStatusAndInformationExtensions tslServiceStatus : status) {
                        Assert.assertTrue((boolean)Utils.isStringNotEmpty((String)tslServiceStatus.getStatus()));
                        Assert.assertTrue((boolean)Utils.isStringNotEmpty((String)tslServiceStatus.getType()));
                        Assert.assertNotNull((Object)tslServiceStatus.getStartDate());
                        ++n;
                    }
                    Assert.assertTrue((n > 0 ? 1 : 0) != 0);
                }
            }
        }
    }

    static {
        countriesWithoutTSP.add("EU");
        countriesWithoutTSP.add("CY");
        countriesWithoutTSP.add("MT");
        countriesWithoutTSP.add("UK");
    }
}

