/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.service;

import eu.europa.esig.dss.client.http.DataLoader;
import eu.europa.esig.dss.client.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.tsl.TSLValidationModel;
import eu.europa.esig.dss.tsl.TrustedListsCertificateSource;
import eu.europa.esig.dss.tsl.service.TSLRepository;
import eu.europa.esig.dss.tsl.service.TSLValidationJob;
import eu.europa.esig.dss.x509.KeyStoreCertificateSource;
import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSLValidationJobTest {
    private static final Logger logger = LoggerFactory.getLogger(TSLValidationJobTest.class);
    private static final String LOTL_URL = "https://ec.europa.eu/information_society/policy/esignature/trusted-list/tl-mp.xml";
    private KeyStoreCertificateSource dssKeyStore;

    @Before
    public void init() {
        this.dssKeyStore = new KeyStoreCertificateSource(new File("src/test/resources/keystore.p12"), "PKCS12", "dss-password");
    }

    @Test
    public void test() {
        TSLRepository repository = new TSLRepository();
        repository.setTrustedListsCertificateSource(new TrustedListsCertificateSource());
        TSLValidationModel spain = repository.getByCountry("ES");
        Assert.assertNull((Object)spain);
        TSLValidationJob job = new TSLValidationJob();
        job.setCheckLOTLSignature(true);
        job.setCheckTSLSignatures(true);
        job.setDataLoader((DataLoader)new CommonsDataLoader());
        job.setLotlUrl(LOTL_URL);
        job.setLotlCode("EU");
        job.setDssKeyStore(this.dssKeyStore);
        job.setRepository(repository);
        job.refresh();
        spain = repository.getByCountry("ES");
        Assert.assertNotNull((Object)spain);
    }

    @Test
    public void testOnlyOneCountry() {
        TSLRepository repository = new TSLRepository();
        repository.setTrustedListsCertificateSource(new TrustedListsCertificateSource());
        TSLValidationModel france = repository.getByCountry("FR");
        Assert.assertNull((Object)france);
        TSLValidationJob job = new TSLValidationJob();
        job.setCheckLOTLSignature(true);
        job.setCheckTSLSignatures(true);
        job.setDataLoader((DataLoader)new CommonsDataLoader());
        job.setLotlUrl(LOTL_URL);
        job.setLotlCode("EU");
        job.setDssKeyStore(this.dssKeyStore);
        job.setRepository(repository);
        ArrayList<String> filterTerritories = new ArrayList<String>();
        filterTerritories.add("FR");
        job.setFilterTerritories(filterTerritories);
        job.refresh();
        france = repository.getByCountry("FR");
        Assert.assertNotNull((Object)france);
        TSLValidationModel spain = repository.getByCountry("ES");
        Assert.assertNull((Object)spain);
    }

    @Test
    public void testCache() {
        TSLRepository repository = new TSLRepository();
        repository.setTrustedListsCertificateSource(new TrustedListsCertificateSource());
        TSLValidationJob job = new TSLValidationJob();
        job.setCheckLOTLSignature(true);
        job.setCheckTSLSignatures(true);
        job.setDataLoader((DataLoader)new CommonsDataLoader());
        job.setLotlUrl(LOTL_URL);
        job.setLotlCode("EU");
        job.setDssKeyStore(this.dssKeyStore);
        job.setRepository(repository);
        logger.info("***************** First load *****************");
        job.refresh();
        logger.info("***************** Second load *****************");
        job.refresh();
    }

    @Test
    public void testWhenCountryTslLoadingFails() throws Exception {
        String lotlUrl = "file:src/test/resources/LOTL-with-err-country.xml";
        TSLRepository repository = new TSLRepository();
        repository.setTrustedListsCertificateSource(new TrustedListsCertificateSource());
        Assert.assertNull((Object)repository.getByCountry("BE"));
        Assert.assertNull((Object)repository.getByCountry("AT"));
        TSLValidationJob job = new TSLValidationJob();
        job.setCheckLOTLSignature(false);
        job.setCheckTSLSignatures(false);
        job.setDataLoader((DataLoader)new CommonsDataLoader());
        job.setLotlUrl(lotlUrl);
        job.setLotlCode("EU");
        job.setDssKeyStore(this.dssKeyStore);
        job.setRepository(repository);
        job.refresh();
        Assert.assertNotNull((Object)repository.getByCountry("BE"));
        Assert.assertNull((Object)repository.getByCountry("AT"));
    }
}

