/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.range;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.math.BigInteger;
import org.dishevelled.bio.range.Ranges;
import org.junit.Assert;
import org.junit.Test;

public final class RangesTest {
    @Test(expected=NullPointerException.class)
    public void testCenterNull() {
        Ranges.center(null);
    }

    @Test(expected=IllegalStateException.class)
    public void testCenterNoBounds() {
        Ranges.center((Range)Range.all());
    }

    @Test
    public void testCenterNoLowerBound() {
        Assert.assertEquals((Object)42L, (Object)Ranges.center((Range)Range.upTo((Comparable)Long.valueOf(42L), (BoundType)BoundType.CLOSED)));
    }

    @Test
    public void testCenterNoUpperBound() {
        Assert.assertEquals((Object)42L, (Object)Ranges.center((Range)Range.downTo((Comparable)Long.valueOf(42L), (BoundType)BoundType.CLOSED)));
    }

    @Test
    public void testCenterInteger() {
        Assert.assertEquals((Object)10, (Object)Ranges.center((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20))));
    }

    @Test
    public void testCenterLong() {
        Assert.assertEquals((Object)10L, (Object)Ranges.center((Range)Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(20L))));
    }

    @Test
    public void testCenterBigInteger() {
        Assert.assertEquals((Object)BigInteger.valueOf(10L), (Object)Ranges.center((Range)Range.closed((Comparable)BigInteger.valueOf(0L), (Comparable)BigInteger.valueOf(20L))));
    }
}

