/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.range.rtree;

import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.RTree;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.google.common.collect.Range;
import org.dishevelled.bio.range.rtree.RangeGeometries;
import org.junit.Assert;
import org.junit.Test;

public final class RangeGeometriesTest {
    @Test(expected=NullPointerException.class)
    public void testSingletonNull() {
        RangeGeometries.singleton(null);
    }

    @Test
    public void testSingleton() {
        Assert.assertEquals((Object)Geometries.point((double)42.0, (double)0.5), (Object)RangeGeometries.singleton((Number)42L));
    }

    @Test(expected=NullPointerException.class)
    public void testClosedNullLower() {
        RangeGeometries.closed(null, (Number)42L);
    }

    @Test(expected=NullPointerException.class)
    public void testClosedNullUpper() {
        RangeGeometries.closed((Number)24L, null);
    }

    @Test
    public void testClosed() {
        Assert.assertEquals((Object)Geometries.rectangle((double)24.0, (double)0.0, (double)42.0, (double)1.0), (Object)RangeGeometries.closed((Number)24L, (Number)42L));
    }

    @Test(expected=NullPointerException.class)
    public void testClosedOpenNullLower() {
        RangeGeometries.closedOpen(null, (Number)42L);
    }

    @Test(expected=NullPointerException.class)
    public void testClosedOpenNullUpper() {
        RangeGeometries.closedOpen((Number)24L, null);
    }

    @Test
    public void testClosedOpen() {
        Assert.assertEquals((Object)Geometries.rectangle((double)24.0, (double)0.0, (double)41.0, (double)1.0), (Object)RangeGeometries.closedOpen((Number)24L, (Number)42L));
    }

    @Test(expected=NullPointerException.class)
    public void testOpenClosedNullLower() {
        RangeGeometries.openClosed(null, (Number)42L);
    }

    @Test(expected=NullPointerException.class)
    public void testOpenClosedNullUpper() {
        RangeGeometries.openClosed((Number)24L, null);
    }

    @Test
    public void testOpenClosed() {
        Assert.assertEquals((Object)Geometries.rectangle((double)25.0, (double)0.0, (double)42.0, (double)1.0), (Object)RangeGeometries.openClosed((Number)24L, (Number)42L));
    }

    @Test(expected=NullPointerException.class)
    public void testOpenNullLower() {
        RangeGeometries.open(null, (Number)42L);
    }

    @Test(expected=NullPointerException.class)
    public void testOpenNullUpper() {
        RangeGeometries.open((Number)24L, null);
    }

    @Test
    public void testOpen() {
        Assert.assertEquals((Object)Geometries.rectangle((double)25.0, (double)0.0, (double)41.0, (double)1.0), (Object)RangeGeometries.open((Number)24L, (Number)42L));
    }

    @Test(expected=NullPointerException.class)
    public void testRangeNullRange() {
        RangeGeometries.range(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRangeEmptyRange() {
        RangeGeometries.range((Range)Range.closedOpen((Comparable)Long.valueOf(42L), (Comparable)Long.valueOf(42L)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRangeNoLowerBound() {
        RangeGeometries.range((Range)Range.lessThan((Comparable)Long.valueOf(42L)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRangeNoUpperBound() {
        RangeGeometries.range((Range)Range.greaterThan((Comparable)Long.valueOf(42L)));
    }

    @Test
    public void testRange() {
        Assert.assertEquals((Object)Geometries.rectangle((double)42.0, (double)0.0, (double)42.0, (double)1.0), (Object)RangeGeometries.range((Range)Range.singleton((Comparable)Long.valueOf(42L))));
        Assert.assertEquals((Object)Geometries.rectangle((double)24.0, (double)0.0, (double)42.0, (double)1.0), (Object)RangeGeometries.range((Range)Range.closed((Comparable)Long.valueOf(24L), (Comparable)Long.valueOf(42L))));
        Assert.assertEquals((Object)Geometries.rectangle((double)24.0, (double)0.0, (double)41.0, (double)1.0), (Object)RangeGeometries.range((Range)Range.closedOpen((Comparable)Long.valueOf(24L), (Comparable)Long.valueOf(42L))));
        Assert.assertEquals((Object)Geometries.rectangle((double)25.0, (double)0.0, (double)42.0, (double)1.0), (Object)RangeGeometries.range((Range)Range.openClosed((Comparable)Long.valueOf(24L), (Comparable)Long.valueOf(42L))));
        Assert.assertEquals((Object)Geometries.rectangle((double)25.0, (double)0.0, (double)41.0, (double)1.0), (Object)RangeGeometries.range((Range)Range.open((Comparable)Long.valueOf(24L), (Comparable)Long.valueOf(42L))));
    }

    @Test
    public void testRTree() {
        RTree rtree = RTree.create();
        rtree = rtree.add((Object)"foo", (Geometry)RangeGeometries.closed((Number)10, (Number)20));
        rtree = rtree.add((Object)"bar", (Geometry)RangeGeometries.closedOpen((Number)14, (Number)28));
        rtree = rtree.add((Object)"baz", (Geometry)RangeGeometries.open((Number)18, (Number)36));
        int count = 0;
        for (Entry result : rtree.search(RangeGeometries.singleton((Number)20)).toBlocking().toIterable()) {
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
    }
}

