/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.range.entrytree;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.List;
import org.dishevelled.bio.range.entrytree.RangeTree;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractRangeTreeTest {
    protected static final int N = 1000;
    protected static final Range<Integer> empty = Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(1));
    protected static final Range<Integer> singleton = Range.singleton((Comparable)Integer.valueOf(1));
    protected static final Range<Integer> miss = Range.singleton((Comparable)Integer.valueOf(-1));
    protected static final Range<Integer> closed = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(100));
    protected static final Range<Integer> open = Range.open((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(100));
    protected static final Range<Integer> closedOpen = Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(100));
    protected static final Range<Integer> openClosed = Range.openClosed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(100));
    protected static final List<Range<Integer>> dense = Lists.newArrayListWithExpectedSize((int)1000);
    protected static final List<Range<Integer>> sparse = Lists.newArrayListWithExpectedSize((int)1000);
    protected static final int M = 10;

    protected abstract <C extends Comparable> RangeTree<C, String> create(Range<C> ... var1);

    protected abstract <C extends Comparable> RangeTree<C, String> create(List<Range<C>> var1);

    @Test
    public void testCreateEmpty() {
        Assert.assertNotNull(this.create(Collections.emptyList()));
    }

    @Test
    public void testCreateEmptyRange() {
        Assert.assertNotNull(this.create(empty));
    }

    @Test
    public void testCreateSingleton() {
        Assert.assertNotNull(this.create(singleton));
    }

    @Test
    public void testCreateSparse() {
        Assert.assertNotNull(this.create(sparse));
    }

    @Test
    public void testCreateDense() {
        Assert.assertNotNull(this.create(dense));
    }

    @Test
    public void testSizeEmpty() {
        Assert.assertEquals((long)0L, (long)this.create(Collections.emptyList()).size());
    }

    @Test
    public void testSizeEmptyRange() {
        Assert.assertEquals((long)1L, (long)this.create(empty).size());
    }

    @Test
    public void testSizeSingeton() {
        Assert.assertEquals((long)1L, (long)this.create(singleton).size());
    }

    @Test
    public void testSizeSparse() {
        Assert.assertEquals((long)sparse.size(), (long)this.create(sparse).size());
    }

    @Test
    public void testSizeDense() {
        Assert.assertEquals((long)dense.size(), (long)this.create(dense).size());
    }

    @Test
    public void testIsEmptyEmpty() {
        Assert.assertTrue((boolean)this.create(Collections.emptyList()).isEmpty());
    }

    @Test
    public void testIsEmptyEmptyRange() {
        Assert.assertFalse((boolean)this.create(empty).isEmpty());
    }

    @Test
    public void testIsEmptySingleton() {
        Assert.assertFalse((boolean)this.create(singleton).isEmpty());
    }

    @Test
    public void testIsEmptySparse() {
        Assert.assertFalse((boolean)this.create(sparse).isEmpty());
    }

    @Test
    public void testIsEmptyDense() {
        Assert.assertFalse((boolean)this.create(dense).isEmpty());
    }

    @Test
    public void testContainsEmpty() {
        Assert.assertFalse((boolean)this.create(empty).contains((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testContainsSingletonMiss() {
        Assert.assertFalse((boolean)this.create(singleton).contains((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testContainsSingletonHit() {
        Assert.assertTrue((boolean)this.create(singleton).contains((Comparable)Integer.valueOf(1)));
    }

    @Test
    public void testContainsSparse() {
        Assert.assertTrue((boolean)this.create(sparse).contains((Comparable)Integer.valueOf(4)));
    }

    @Test
    public void testContainsDense() {
        Assert.assertTrue((boolean)this.create(dense).contains((Comparable)Integer.valueOf(4)));
    }

    @Test
    public void testCountEmpty() {
        Assert.assertEquals((long)0L, (long)this.create(empty).count((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testCountSingletonMiss() {
        Assert.assertEquals((long)0L, (long)this.create(singleton).count((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testCountSingletonHit() {
        Assert.assertEquals((long)1L, (long)this.create(singleton).count((Comparable)Integer.valueOf(1)));
    }

    @Test
    public void testCountDense() {
        Assert.assertEquals((long)5L, (long)this.create(dense).count((Comparable)Integer.valueOf(4)));
    }

    @Test
    public void testCountSparse() {
        Assert.assertEquals((long)1L, (long)this.create(sparse).count((Comparable)Integer.valueOf(4)));
    }

    @Test
    public void testQueryEmpty() {
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.create(empty).query((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void testQuerySingletonMiss() {
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.create(singleton).query((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void testQuerySingletonHit() {
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.create(singleton).query((Comparable)Integer.valueOf(1))));
    }

    @Test
    public void testQueryDense() {
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)this.create(dense).query((Comparable)Integer.valueOf(4))));
    }

    @Test
    public void testQuerySparse() {
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.create(sparse).query((Comparable)Integer.valueOf(4))));
    }

    @Test(expected=NullPointerException.class)
    public void testCountNullRange() {
        this.create(sparse).count((Range)null);
    }

    @Test
    public void testCountEmptyEmptyRange() {
        Assert.assertEquals((long)0L, (long)this.create(empty).count(empty));
    }

    @Test
    public void testCountEmptySingletonRange() {
        Assert.assertEquals((long)0L, (long)this.create(empty).count(singleton));
    }

    @Test
    public void testCountEmptyClosedRange() {
        Assert.assertEquals((long)0L, (long)this.create(empty).count(closed));
    }

    @Test
    public void testCountEmptyOpenRange() {
        Assert.assertEquals((long)0L, (long)this.create(empty).count(open));
    }

    @Test
    public void testCountEmptyClosedOpenRange() {
        Assert.assertEquals((long)0L, (long)this.create(empty).count(closedOpen));
    }

    @Test
    public void testCountEmptyOpenClosedRange() {
        Assert.assertEquals((long)0L, (long)this.create(empty).count(openClosed));
    }

    @Test
    public void testCountSingletonEmptyRange() {
        Assert.assertEquals((long)0L, (long)this.create(singleton).count(empty));
    }

    @Test
    public void testCountSingletonSingletonRangeMiss() {
        Assert.assertEquals((long)0L, (long)this.create(singleton).count(miss));
    }

    @Test
    public void testCountSingletonSingletonRangeHit() {
        Assert.assertEquals((long)1L, (long)this.create(singleton).count(singleton));
    }

    @Test
    public void testCountSingletonClosedRange() {
        Assert.assertEquals((long)1L, (long)this.create(singleton).count(closed));
    }

    @Test
    public void testCountSingletonOpenRange() {
        Assert.assertEquals((long)0L, (long)this.create(singleton).count(open));
    }

    @Test
    public void testCountSingletonClosedOpenRange() {
        Assert.assertEquals((long)1L, (long)this.create(singleton).count(closedOpen));
    }

    @Test
    public void testCountSingletonOpenClosedRange() {
        Assert.assertEquals((long)0L, (long)this.create(singleton).count(openClosed));
    }

    @Test
    public void testCountSparseEmptyRange() {
        Assert.assertEquals((long)0L, (long)this.create(sparse).count(empty));
    }

    @Test
    public void testCountSparseSingletonRangeMiss() {
        Assert.assertEquals((long)0L, (long)this.create(sparse).count(miss));
    }

    @Test
    public void testCountSparseSingletonRangeHit() {
        Assert.assertEquals((long)1L, (long)this.create(sparse).count(singleton));
    }

    @Test
    public void testCountSparseClosedRange() {
        Assert.assertEquals((long)2L, (long)this.create(sparse).count(closed));
    }

    @Test
    public void testCountSparseOpenRange() {
        Assert.assertEquals((long)1L, (long)this.create(sparse).count(open));
    }

    @Test
    public void testCountSparseClosedOpenRange() {
        Assert.assertEquals((long)1L, (long)this.create(sparse).count(closedOpen));
    }

    @Test
    public void testCountSparseOpenClosedRange() {
        Assert.assertEquals((long)2L, (long)this.create(sparse).count(openClosed));
    }

    @Test
    public void testCountDenseEmptyRange() {
        Assert.assertEquals((long)0L, (long)this.create(dense).count(empty));
    }

    @Test
    public void testCountDenseSingletonRangeMiss() {
        Assert.assertEquals((long)0L, (long)this.create(dense).count(miss));
    }

    @Test
    public void testCountDenseSingletonRangeHit() {
        Assert.assertEquals((long)2L, (long)this.create(dense).count(singleton));
    }

    @Test
    public void testCountDenseClosedRange() {
        Assert.assertEquals((long)101L, (long)this.create(dense).count(closed));
    }

    @Test
    public void testCountDenseOpenRange() {
        Assert.assertEquals((long)100L, (long)this.create(dense).count(open));
    }

    @Test
    public void testCountDenseClosedOpenRange() {
        Assert.assertEquals((long)100L, (long)this.create(dense).count(closedOpen));
    }

    @Test
    public void testCountDenseOpenClosedRange() {
        Assert.assertEquals((long)101L, (long)this.create(dense).count(openClosed));
    }

    @Test(expected=NullPointerException.class)
    public void testIntersectNullRange() {
        this.create(sparse).intersect((Range)null);
    }

    @Test
    public void testIntersectEmptyEmptyRange() {
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.create(empty).intersect(empty)));
    }

    @Test
    public void testIntersectEmptySingletonRange() {
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.create(empty).intersect(singleton)));
    }

    @Test
    public void testIntersectEmptyClosedRange() {
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.create(empty).intersect(closed)));
    }

    @Test
    public void testIntersectEmptyOpenRange() {
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.create(empty).intersect(open)));
    }

    @Test
    public void testIntersectEmptyClosedOpenRange() {
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.create(empty).intersect(closedOpen)));
    }

    @Test
    public void testIntersectEmptyOpenClosedRange() {
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.create(empty).intersect(openClosed)));
    }

    @Test
    public void testIntersectSingletonEmptyRange() {
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.create(singleton).intersect(empty)));
    }

    @Test
    public void testIntersectSingletonSingletonRangeMiss() {
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.create(singleton).intersect(miss)));
    }

    @Test
    public void testIntersectSingletonSingletonRangeHit() {
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.create(singleton).intersect(singleton)));
    }

    @Test
    public void testIntersectSingletonClosedRange() {
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.create(singleton).intersect(closed)));
    }

    @Test
    public void testIntersectSingletonOpenRange() {
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.create(singleton).intersect(open)));
    }

    @Test
    public void testIntersectSingletonClosedOpenRange() {
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.create(singleton).intersect(closedOpen)));
    }

    @Test
    public void testIntersectSingletonOpenClosedRange() {
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.create(singleton).intersect(openClosed)));
    }

    @Test
    public void testIntersectSparseEmptyRange() {
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.create(sparse).intersect(empty)));
    }

    @Test
    public void testIntersectSparseSingletonRangeMiss() {
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.create(sparse).intersect(miss)));
    }

    @Test
    public void testIntersectSparseSingletonRangeHit() {
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.create(sparse).intersect(singleton)));
    }

    @Test
    public void testIntersectSparseClosedRange() {
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.create(sparse).intersect(closed)));
    }

    @Test
    public void testIntersectSparseOpenRange() {
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.create(sparse).intersect(open)));
    }

    @Test
    public void testIntersectSparseClosedOpenRange() {
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.create(sparse).intersect(closedOpen)));
    }

    @Test
    public void testIntersectSparseOpenClosedRange() {
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.create(sparse).intersect(openClosed)));
    }

    @Test
    public void testIntersectDenseEmptyRange() {
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.create(dense).intersect(empty)));
    }

    @Test
    public void testIntersectDenseSingletonRangeMiss() {
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.create(dense).intersect(miss)));
    }

    @Test
    public void testIntersectDenseSingletonRangeHit() {
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.create(dense).intersect(singleton)));
    }

    @Test
    public void testIntersectDenseClosedRange() {
        Assert.assertEquals((long)101L, (long)Iterables.size((Iterable)this.create(dense).intersect(closed)));
    }

    @Test
    public void testIntersectDenseOpenRange() {
        Assert.assertEquals((long)100L, (long)Iterables.size((Iterable)this.create(dense).intersect(open)));
    }

    @Test
    public void testIntersectDenseClosedOpenRange() {
        Assert.assertEquals((long)100L, (long)Iterables.size((Iterable)this.create(dense).intersect(closedOpen)));
    }

    @Test
    public void testIntersectDenseOpenClosedRange() {
        Assert.assertEquals((long)101L, (long)Iterables.size((Iterable)this.create(dense).intersect(openClosed)));
    }

    @Test(expected=NullPointerException.class)
    public void testIntersectsNullRange() {
        this.create(sparse).intersects((Range)null);
    }

    @Test(expected=NullPointerException.class)
    public void testIntersectsNullRanges() {
        this.create(sparse).intersects((Iterable)null);
    }

    @Test
    public void testCountDuplicateRanges() {
        Assert.assertEquals((long)4L, (long)this.create(closed, closed, closed, closed).count(closed));
    }

    private void countMany(RangeTree<Integer, String> tree) {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 1000; ++j) {
                Assert.assertTrue((tree.count((Comparable)Integer.valueOf(j)) > -1 ? 1 : 0) != 0);
                Assert.assertNotNull((Object)tree.query((Comparable)Integer.valueOf(j)));
            }
        }
    }

    @Test
    public void testCreateOnceCountManyEmpty() {
        this.countMany(this.create(empty));
    }

    @Test
    public void testCreateOnceCountManySparse() {
        this.countMany(this.create(sparse));
    }

    @Test
    public void testCreateOnceCountManyDense() {
        this.countMany(this.create(dense));
    }

    static {
        for (int i = 0; i < 1000; ++i) {
            dense.add((Range<Integer>)Range.closed((Comparable)Integer.valueOf(i), (Comparable)Integer.valueOf(i + 100)));
            sparse.add((Range<Integer>)Range.closed((Comparable)Integer.valueOf(i * 100), (Comparable)Integer.valueOf(i * 100 + 100)));
        }
    }
}

