/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.range;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import java.math.BigInteger;

public final class Ranges {
    private Ranges() {
    }

    public static <C extends Comparable> C center(Range<C> range) {
        Preconditions.checkNotNull(range);
        if (!range.hasLowerBound() && !range.hasUpperBound()) {
            throw new IllegalStateException("cannot find the center of a range without bounds");
        }
        if (!range.hasLowerBound()) {
            return (C)range.upperEndpoint();
        }
        if (!range.hasUpperBound()) {
            return (C)range.lowerEndpoint();
        }
        Comparable lowerEndpoint = range.lowerEndpoint();
        Comparable upperEndpoint = range.upperEndpoint();
        if (upperEndpoint instanceof Integer) {
            Integer upper = (Integer)upperEndpoint;
            Integer lower = (Integer)lowerEndpoint;
            return (C)Integer.valueOf((upper + lower) / 2);
        }
        if (upperEndpoint instanceof Long) {
            Long upper = (Long)upperEndpoint;
            Long lower = (Long)lowerEndpoint;
            return (C)Long.valueOf((upper + lower) / 2L);
        }
        if (upperEndpoint instanceof BigInteger) {
            BigInteger upper = (BigInteger)upperEndpoint;
            BigInteger lower = (BigInteger)lowerEndpoint;
            BigInteger two = BigInteger.valueOf(2L);
            return (C)upper.subtract(lower).divide(two);
        }
        throw new IllegalStateException("cannot find the center of a range whose endpoint type is not Integer, Long, or BigInteger");
    }

    public static <C extends Comparable> boolean intersect(Range<C> range0, Range<C> range1) {
        Preconditions.checkNotNull(range0);
        Preconditions.checkNotNull(range1);
        return range0.isConnected(range1) && !range0.intersection(range1).isEmpty();
    }

    public static <C extends Comparable> boolean isLessThan(Range<C> range, C value) {
        Preconditions.checkNotNull(range);
        Preconditions.checkNotNull(value);
        if (!range.hasUpperBound()) {
            return false;
        }
        if (range.upperBoundType() == BoundType.OPEN && range.upperEndpoint().equals(value)) {
            return true;
        }
        return range.upperEndpoint().compareTo(value) < 0;
    }

    public static <C extends Comparable> boolean isGreaterThan(Range<C> range, C value) {
        Preconditions.checkNotNull(range);
        Preconditions.checkNotNull(value);
        if (!range.hasLowerBound()) {
            return false;
        }
        if (range.lowerBoundType() == BoundType.OPEN && range.lowerEndpoint().equals(value)) {
            return true;
        }
        return range.lowerEndpoint().compareTo(value) > 0;
    }

    public static <C extends Comparable> Ordering<Range<C>> orderingByLowerEndpoint() {
        return new Ordering<Range<C>>(){

            public int compare(Range<C> left, Range<C> right) {
                return ComparisonChain.start().compare(Boolean.valueOf(left.hasLowerBound()), Boolean.valueOf(right.hasLowerBound())).compare(left.lowerEndpoint(), right.lowerEndpoint()).result();
            }
        };
    }

    public static <C extends Comparable> Ordering<Range<C>> reverseOrderingByLowerEndpoint() {
        Ordering<Range<C>> orderingByLowerEndpoint = Ranges.orderingByLowerEndpoint();
        return orderingByLowerEndpoint.reverse();
    }

    public static <C extends Comparable> Ordering<Range<C>> orderingByUpperEndpoint() {
        return new Ordering<Range<C>>(){

            public int compare(Range<C> left, Range<C> right) {
                return ComparisonChain.start().compare(Boolean.valueOf(left.hasUpperBound()), Boolean.valueOf(right.hasUpperBound())).compare(left.upperEndpoint(), right.upperEndpoint()).result();
            }
        };
    }

    public static <C extends Comparable> Ordering<Range<C>> reverseOrderingByUpperEndpoint() {
        Ordering<Range<C>> orderingByUpperEndpoint = Ranges.orderingByUpperEndpoint();
        return orderingByUpperEndpoint.reverse();
    }
}

