/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.range.entrytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import java.util.Iterator;
import org.dishevelled.bio.range.entrytree.RangeTree;

public abstract class AbstractRangeTree<C extends Comparable, V>
implements RangeTree<C, V> {
    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(C location) {
        return this.count(location) > 0;
    }

    @Override
    public int count(C location) {
        return this.count(Range.singleton(location));
    }

    @Override
    public Iterable<RangeTree.Entry<C, V>> query(C location) {
        return this.intersect(Range.singleton(location));
    }

    @Override
    public int count(Range<C> query) {
        return Iterables.size(this.intersect(query));
    }

    @Override
    public boolean intersects(Range<C> query) {
        return this.count(query) > 0;
    }

    @Override
    public boolean intersects(Iterable<Range<C>> query) {
        Preconditions.checkNotNull(query);
        for (Range<C> range : query) {
            Iterator iterator = this.intersect(range).iterator();
            if (!iterator.hasNext()) continue;
            RangeTree.Entry entry = iterator.next();
            return true;
        }
        return false;
    }
}

