/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.range.entrytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.dishevelled.bio.range.Ranges;
import org.dishevelled.bio.range.entrytree.AbstractRangeTree;
import org.dishevelled.bio.range.entrytree.RangeEntry;
import org.dishevelled.bio.range.entrytree.RangeTree;

public final class CenteredRangeTree<C extends Comparable, V>
extends AbstractRangeTree<C, V> {
    private final int size;
    private final Node root;

    private CenteredRangeTree(Iterable<RangeTree.Entry<C, V>> entries) {
        Preconditions.checkNotNull(entries);
        this.size = Iterables.size(entries);
        this.root = this.createNode(entries);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterable<RangeTree.Entry<C, V>> intersect(Range<C> range) {
        Preconditions.checkNotNull(range);
        LinkedList result = Lists.newLinkedList();
        HashSet visited = Sets.newHashSet();
        this.depthFirstSearch(range, this.root, result, visited);
        return result;
    }

    private Node createNode(Iterable<RangeTree.Entry<C, V>> entries) {
        RangeTree.Entry first = (RangeTree.Entry)Iterables.getFirst(entries, null);
        if (first == null) {
            return null;
        }
        Range span = first.getRange();
        for (RangeTree.Entry<C, V> entry : entries) {
            Range<C> range = entry.getRange();
            span = range.span(span);
        }
        if (span.isEmpty()) {
            return null;
        }
        Object center = Ranges.center(span);
        ArrayList left = Lists.newArrayList();
        ArrayList right = Lists.newArrayList();
        ArrayList overlap = Lists.newArrayList();
        for (RangeTree.Entry<C, V> entry : entries) {
            Range<C> range = entry.getRange();
            if (Ranges.isLessThan(range, center)) {
                left.add(entry);
                continue;
            }
            if (Ranges.isGreaterThan(range, center)) {
                right.add(entry);
                continue;
            }
            overlap.add(entry);
        }
        return new Node(this, center, this.createNode(left), this.createNode(right), (List)overlap);
    }

    private void depthFirstSearch(Range<C> query, Node node, List<RangeTree.Entry<C, V>> result, Set<Node> visited) {
        if (node == null || visited.contains(node) || query.isEmpty()) {
            return;
        }
        if (node.left() != null && Ranges.isLessThan(query, node.center())) {
            this.depthFirstSearch(query, node.left(), result, visited);
        } else if (node.right() != null && Ranges.isGreaterThan(query, node.center())) {
            this.depthFirstSearch(query, node.right(), result, visited);
        }
        if (Ranges.isGreaterThan(query, node.center())) {
            for (RangeTree.Entry entry : node.overlapByUpperEndpoint()) {
                Range range = entry.getRange();
                if (Ranges.intersect(range, query)) {
                    result.add(entry);
                }
                if (!Ranges.isGreaterThan(query, range.upperEndpoint())) continue;
                break;
            }
        } else if (Ranges.isLessThan(query, node.center())) {
            for (RangeTree.Entry entry : node.overlapByLowerEndpoint()) {
                Range range = entry.getRange();
                if (Ranges.intersect(range, query)) {
                    result.add(entry);
                }
                if (!Ranges.isLessThan(query, range.lowerEndpoint())) continue;
                break;
            }
        } else {
            result.addAll(node.overlapByLowerEndpoint());
        }
        visited.add(node);
    }

    public static <C extends Comparable, V> RangeTree<C, V> create(Iterable<RangeTree.Entry<C, V>> entries) {
        return new CenteredRangeTree<C, V>(entries);
    }

    public static <C extends Comparable, V> RangeTree<C, V> create(List<Range<C>> ranges, List<V> values) {
        Preconditions.checkNotNull(ranges);
        Preconditions.checkNotNull(values);
        Preconditions.checkArgument((ranges.size() == values.size() ? 1 : 0) != 0, (Object)"entries and values must be equal size");
        int size = ranges.size();
        ArrayList entries = Lists.newArrayListWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            entries.add(new RangeEntry<C, V>(ranges.get(i), values.get(i)));
        }
        return new CenteredRangeTree<C, V>(entries);
    }

    private class EntryOrdering
    extends Ordering<RangeTree.Entry<C, V>> {
        private final Ordering<Range<C>> rangeOrdering;
        private final Ordering<V> valueOrdering;

        private EntryOrdering(Ordering<Range<C>> rangeOrdering) {
            Preconditions.checkNotNull(rangeOrdering);
            this.rangeOrdering = rangeOrdering;
            this.valueOrdering = new AllEqualOrdering();
        }

        public int compare(RangeTree.Entry<C, V> left, RangeTree.Entry<C, V> right) {
            return ComparisonChain.start().compare(left.getRange(), right.getRange(), this.rangeOrdering).compare(left.getValue(), right.getValue(), this.valueOrdering).result();
        }
    }

    private class AllEqualOrdering
    extends Ordering<V> {
        private AllEqualOrdering() {
        }

        public int compare(V left, V right) {
            return 0;
        }
    }

    private static class Node {
        private final C center;
        private final Node left;
        private final Node right;
        private final List<RangeTree.Entry<C, V>> overlapByLowerEndpoint;
        private final List<RangeTree.Entry<C, V>> overlapByUpperEndpoint;
        final /* synthetic */ CenteredRangeTree this$0;

        Node(C center, Node left, Node right, List<RangeTree.Entry<C, V>> overlap) {
            this.this$0 = var1_1;
            this.center = center;
            this.left = left;
            this.right = right;
            this.overlapByLowerEndpoint = Lists.newArrayList(overlap);
            this.overlapByUpperEndpoint = Lists.newArrayList(overlap);
            Ordering orderingByLowerEndpoint = Ranges.orderingByLowerEndpoint();
            Ordering reverseOrderingByUpperEndpoint = Ranges.reverseOrderingByUpperEndpoint();
            EntryOrdering entryOrderingByLowerEndpoint = var1_1.new EntryOrdering(orderingByLowerEndpoint);
            EntryOrdering entryReverseOrderingByUpperEndpoint = var1_1.new EntryOrdering(reverseOrderingByUpperEndpoint);
            this.overlapByLowerEndpoint.sort((Comparator)((Object)entryOrderingByLowerEndpoint));
            this.overlapByUpperEndpoint.sort((Comparator)((Object)entryReverseOrderingByUpperEndpoint));
        }

        C center() {
            return this.center;
        }

        Node left() {
            return this.left;
        }

        Node right() {
            return this.right;
        }

        List<RangeTree.Entry<C, V>> overlapByLowerEndpoint() {
            return this.overlapByLowerEndpoint;
        }

        List<RangeTree.Entry<C, V>> overlapByUpperEndpoint() {
            return this.overlapByUpperEndpoint;
        }
    }
}

