/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.range.entrytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import javax.annotation.concurrent.Immutable;
import org.dishevelled.bio.range.entrytree.RangeTree;

@Immutable
public final class RangeEntry<C extends Comparable, V>
implements RangeTree.Entry<C, V> {
    private final Range<C> range;
    private final V value;

    public RangeEntry(Range<C> range, V value) {
        Preconditions.checkNotNull(range);
        this.range = range;
        this.value = value;
    }

    @Override
    public Range<C> getRange() {
        return this.range;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.range.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RangeTree.Entry)) {
            return false;
        }
        RangeTree.Entry e = (RangeTree.Entry)o;
        return this.range.equals(e.getRange()) && this.value == null ? e.getValue() == null : this.value.equals(e.getValue());
    }
}

