/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.range.rtree;

import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Point;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;

public final class RangeGeometries {
    private RangeGeometries() {
    }

    public static <N extends Number> Point singleton(N value) {
        Preconditions.checkNotNull(value);
        return Geometries.point((double)value.doubleValue(), (double)0.5);
    }

    public static <N extends Number> Rectangle closed(N lower, N upper) {
        Preconditions.checkNotNull(lower);
        Preconditions.checkNotNull(upper);
        return RangeGeometries.range(Range.closed((Comparable)((Comparable)((Object)lower)), (Comparable)((Comparable)((Object)upper))));
    }

    public static <N extends Number> Rectangle closedOpen(N lower, N upper) {
        Preconditions.checkNotNull(lower);
        Preconditions.checkNotNull(upper);
        return RangeGeometries.range(Range.closedOpen((Comparable)((Comparable)((Object)lower)), (Comparable)((Comparable)((Object)upper))));
    }

    public static <N extends Number> Rectangle openClosed(N lower, N upper) {
        Preconditions.checkNotNull(lower);
        Preconditions.checkNotNull(upper);
        return RangeGeometries.range(Range.openClosed((Comparable)((Comparable)((Object)lower)), (Comparable)((Comparable)((Object)upper))));
    }

    public static <N extends Number> Rectangle open(N lower, N upper) {
        Preconditions.checkNotNull(lower);
        Preconditions.checkNotNull(upper);
        return RangeGeometries.range(Range.open((Comparable)((Comparable)((Object)lower)), (Comparable)((Comparable)((Object)upper))));
    }

    public static <N extends Number> Rectangle range(Range<N> range) {
        Preconditions.checkNotNull(range);
        if (range.isEmpty()) {
            throw new IllegalArgumentException("range must not be empty");
        }
        if (!range.hasLowerBound() || !range.hasUpperBound()) {
            throw new IllegalArgumentException("range must have lower and upper bounds");
        }
        Number lowerEndpoint = (Number)((Object)range.lowerEndpoint());
        BoundType lowerBoundType = range.lowerBoundType();
        Number upperEndpoint = (Number)((Object)range.upperEndpoint());
        BoundType upperBoundType = range.upperBoundType();
        double x1 = lowerBoundType == BoundType.OPEN ? lowerEndpoint.doubleValue() + 1.0 : lowerEndpoint.doubleValue();
        double y1 = 0.0;
        double x2 = upperBoundType == BoundType.OPEN ? upperEndpoint.doubleValue() - 1.0 : upperEndpoint.doubleValue();
        double y2 = 1.0;
        return Geometries.rectangle((double)x1, (double)y1, (double)x2, (double)y2);
    }
}

