/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.range.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.dishevelled.bio.range.tree.RangeTree;

public abstract class AbstractRangeTree<C extends Comparable>
implements RangeTree<C> {
    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(C location) {
        return this.count(location) > 0;
    }

    @Override
    public int count(C location) {
        return this.count(Range.singleton(location));
    }

    @Override
    public Iterable<Range<C>> query(C location) {
        return this.intersect(Range.singleton(location));
    }

    @Override
    public int count(Range<C> query) {
        return Iterables.size(this.intersect(query));
    }

    @Override
    public boolean intersects(Range<C> query) {
        return this.count(query) > 0;
    }

    @Override
    public Iterable<Set<Range<C>>> intersect(Iterable<Range<C>> query) {
        Preconditions.checkNotNull(query);
        LinkedList result = Lists.newLinkedList();
        for (Range<C> range0 : query) {
            for (Range<C> range1 : this.intersect(range0)) {
                result.add(ImmutableSet.of(range0, range1));
            }
        }
        return result;
    }

    @Override
    public boolean intersects(Iterable<Range<C>> query) {
        Preconditions.checkNotNull(query);
        for (Range<C> range0 : query) {
            Iterator<Range<C>> iterator = this.intersect(range0).iterator();
            if (!iterator.hasNext()) continue;
            Range<C> range1 = iterator.next();
            return true;
        }
        return false;
    }
}

