/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.range.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.dishevelled.bio.range.Ranges;
import org.dishevelled.bio.range.tree.AbstractRangeTree;
import org.dishevelled.bio.range.tree.RangeTree;

public final class CenteredRangeTree<C extends Comparable>
extends AbstractRangeTree<C> {
    private final int size;
    private final Node root;

    private CenteredRangeTree(Iterable<Range<C>> ranges) {
        Preconditions.checkNotNull(ranges);
        this.size = Iterables.size(ranges);
        this.root = this.createNode(ranges);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterable<Range<C>> intersect(Range<C> range) {
        Preconditions.checkNotNull(range);
        LinkedList result = Lists.newLinkedList();
        HashSet visited = Sets.newHashSet();
        this.depthFirstSearch(range, this.root, result, visited);
        return result;
    }

    private Node createNode(Iterable<Range<C>> ranges) {
        Range span = (Range)Iterables.getFirst(ranges, null);
        if (span == null) {
            return null;
        }
        for (Range<C> range : ranges) {
            Preconditions.checkNotNull(range, (Object)"ranges must not contain null ranges");
            span = range.span(span);
        }
        if (span.isEmpty()) {
            return null;
        }
        Object center = Ranges.center(span);
        ArrayList left = Lists.newArrayList();
        ArrayList right = Lists.newArrayList();
        ArrayList overlap = Lists.newArrayList();
        for (Range<C> range : ranges) {
            if (Ranges.isLessThan(range, center)) {
                left.add(range);
                continue;
            }
            if (Ranges.isGreaterThan(range, center)) {
                right.add(range);
                continue;
            }
            overlap.add(range);
        }
        return new Node(this, center, this.createNode(left), this.createNode(right), (List)overlap);
    }

    private void depthFirstSearch(Range<C> query, Node node, List<Range<C>> result, Set<Node> visited) {
        if (node == null || visited.contains(node) || query.isEmpty()) {
            return;
        }
        if (node.left() != null && Ranges.isLessThan(query, node.center())) {
            this.depthFirstSearch(query, node.left(), result, visited);
        } else if (node.right() != null && Ranges.isGreaterThan(query, node.center())) {
            this.depthFirstSearch(query, node.right(), result, visited);
        }
        if (Ranges.isGreaterThan(query, node.center())) {
            for (Range range : node.overlapByUpperEndpoint()) {
                if (Ranges.intersect(range, query)) {
                    result.add(range);
                }
                if (!Ranges.isGreaterThan(query, range.upperEndpoint())) continue;
                break;
            }
        } else if (Ranges.isLessThan(query, node.center())) {
            for (Range range : node.overlapByLowerEndpoint()) {
                if (Ranges.intersect(range, query)) {
                    result.add(range);
                }
                if (!Ranges.isLessThan(query, range.lowerEndpoint())) continue;
                break;
            }
        } else {
            result.addAll(node.overlapByLowerEndpoint());
        }
        visited.add(node);
    }

    public static <C extends Comparable> RangeTree<C> create(Iterable<Range<C>> ranges) {
        return new CenteredRangeTree<C>(ranges);
    }

    private static class Node {
        private final C center;
        private final Node left;
        private final Node right;
        private final List<Range<C>> overlapByLowerEndpoint;
        private final List<Range<C>> overlapByUpperEndpoint;
        final /* synthetic */ CenteredRangeTree this$0;

        Node(C center, Node left, Node right, List<Range<C>> overlap) {
            this.this$0 = var1_1;
            this.center = center;
            this.left = left;
            this.right = right;
            this.overlapByLowerEndpoint = Lists.newArrayList(overlap);
            this.overlapByUpperEndpoint = Lists.newArrayList(overlap);
            Ordering orderingByLowerEndpoint = Ranges.orderingByLowerEndpoint();
            Ordering reverseOrderingByUpperEndpoint = Ranges.reverseOrderingByUpperEndpoint();
            this.overlapByLowerEndpoint.sort((Comparator)orderingByLowerEndpoint);
            this.overlapByUpperEndpoint.sort((Comparator)reverseOrderingByUpperEndpoint);
        }

        C center() {
            return this.center;
        }

        Node left() {
            return this.left;
        }

        Node right() {
            return this.right;
        }

        List<Range<C>> overlapByLowerEndpoint() {
            return this.overlapByLowerEndpoint;
        }

        List<Range<C>> overlapByUpperEndpoint() {
            return this.overlapByUpperEndpoint;
        }
    }
}

