/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.bio.range.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.LinkedList;
import java.util.List;
import org.dishevelled.bio.range.Ranges;
import org.dishevelled.bio.range.tree.AbstractRangeTree;
import org.dishevelled.bio.range.tree.RangeTree;

public final class RangeList<C extends Comparable>
extends AbstractRangeTree<C> {
    private final List<Range<C>> ranges;

    private RangeList(Iterable<Range<C>> ranges) {
        Preconditions.checkNotNull(ranges);
        this.ranges = ImmutableList.copyOf(ranges);
    }

    @Override
    public int size() {
        return this.ranges.size();
    }

    @Override
    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    @Override
    public Iterable<Range<C>> intersect(Range<C> query) {
        Preconditions.checkNotNull(query);
        LinkedList result = Lists.newLinkedList();
        for (Range<C> range : this.ranges) {
            if (!Ranges.intersect(range, query)) continue;
            result.add(range);
        }
        return result;
    }

    public static <C extends Comparable> RangeTree<C> create(Iterable<Range<C>> ranges) {
        return new RangeList<C>(ranges);
    }
}

