/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.httpurlconnection;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.dmfs.httpessentials.client.HttpResponseEntity;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.httpessentials.types.StringMediaType;
import org.dmfs.optional.Absent;
import org.dmfs.optional.Optional;
import org.dmfs.optional.Present;

final class HttpUrlConnectionResponseEntity
implements HttpResponseEntity {
    private final HttpURLConnection mConnection;

    public HttpUrlConnectionResponseEntity(HttpURLConnection connection) {
        this.mConnection = connection;
    }

    public Optional<MediaType> contentType() {
        String mediaType = this.mConnection.getContentType();
        return mediaType == null ? Absent.absent() : new Present((Object)new StringMediaType(mediaType));
    }

    public Optional<Long> contentLength() {
        long length = this.mConnection.getContentLengthLong();
        return length < 0L ? Absent.absent() : new Present((Object)length);
    }

    public InputStream contentStream() throws IOException {
        if (this.mConnection.getResponseCode() < 400) {
            return this.mConnection.getInputStream();
        }
        return this.mConnection.getErrorStream();
    }
}

