/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client;

import java.net.URI;
import org.dmfs.httpessentials.converters.PlainStringHeaderConverter;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.parameters.BasicParameterType;
import org.dmfs.httpessentials.parameters.ParameterType;
import org.dmfs.httpessentials.parameters.Parametrized;
import org.dmfs.httpessentials.typedentity.EntityConverter;
import org.dmfs.httpessentials.types.UrlFormEncodedKeyValues;
import org.dmfs.oauth2.client.OAuth2AuthCodeAuthorization;
import org.dmfs.oauth2.client.OAuth2Scope;

public final class BasicOAuth2AuthCodeAuthorization
implements OAuth2AuthCodeAuthorization {
    private static final ParameterType<String> AUTH_CODE = new BasicParameterType("code", (EntityConverter)PlainStringHeaderConverter.INSTANCE);
    private static final ParameterType<String> STATE = new BasicParameterType("state", (EntityConverter)PlainStringHeaderConverter.INSTANCE);
    private final Parametrized mFragment;
    private final OAuth2Scope mScope;

    public BasicOAuth2AuthCodeAuthorization(URI redirectUri, OAuth2Scope requestedScope, String state) throws ProtocolException {
        this.mFragment = new UrlFormEncodedKeyValues(redirectUri.getRawQuery());
        if (!state.equals(this.mFragment.firstParameter(STATE, (Object)"").value())) {
            throw new ProtocolException("State in redirect uri doesn't match the original state!");
        }
        if (!this.mFragment.hasParameter(AUTH_CODE)) {
            throw new ProtocolException(String.format("Missing access_token in fragment '%s'", this.mFragment.toString()));
        }
        this.mScope = requestedScope;
    }

    @Override
    public String code() {
        return (String)this.mFragment.firstParameter(AUTH_CODE, (Object)"").value();
    }

    @Override
    public OAuth2Scope scope() {
        return this.mScope;
    }
}

