/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client;

import java.net.URI;
import java.net.URISyntaxException;
import org.dmfs.oauth2.client.OAuth2AuthorizationRequest;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.http.entities.XWwwFormUrlEncodedEntity;
import org.dmfs.oauth2.client.utils.ImmutableEntry;

public final class BasicOAuth2AuthorizationRequest
implements OAuth2AuthorizationRequest {
    private final ImmutableEntry[] mParameters;

    public BasicOAuth2AuthorizationRequest(String responseType, String state) {
        this(new ImmutableEntry("response_type", responseType), new ImmutableEntry("state", state));
    }

    public BasicOAuth2AuthorizationRequest(String responseType, OAuth2Scope scope, String state) {
        this(new ImmutableEntry("response_type", responseType), new ImmutableEntry("scope", scope.toString()), new ImmutableEntry("state", state));
    }

    private BasicOAuth2AuthorizationRequest(ImmutableEntry ... parameters) {
        this.mParameters = parameters;
    }

    @Override
    public OAuth2AuthorizationRequest withClientId(String clientId) {
        return this.withEntry(new ImmutableEntry("client_id", clientId));
    }

    @Override
    public OAuth2AuthorizationRequest withRedirectUri(URI redirectUri) {
        return this.withEntry(new ImmutableEntry("redirect_uri", redirectUri.toASCIIString()));
    }

    private OAuth2AuthorizationRequest withEntry(ImmutableEntry entry) {
        ImmutableEntry[] result = new ImmutableEntry[this.mParameters.length + 1];
        int count = this.mParameters.length;
        for (int i = 0; i < count; ++i) {
            ImmutableEntry parameter = this.mParameters[i];
            if (parameter.getKey().equals(entry.getKey())) {
                ImmutableEntry[] clonedResult = (ImmutableEntry[])this.mParameters.clone();
                clonedResult[i] = entry;
                return new BasicOAuth2AuthorizationRequest(clonedResult);
            }
            result[i] = this.mParameters[i];
        }
        result[this.mParameters.length] = entry;
        return new BasicOAuth2AuthorizationRequest(result);
    }

    @Override
    public URI authorizationUri(URI authorizationEndpoint) {
        try {
            return URI.create(String.format("%s?%s", new URI(authorizationEndpoint.getScheme(), authorizationEndpoint.getAuthority(), authorizationEndpoint.getPath(), null, null).toASCIIString(), new XWwwFormUrlEncodedEntity(this.mParameters).toString()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Can't create valid authorization URI", e);
        }
    }
}

