/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.http.entities;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.dmfs.httpessentials.client.HttpRequestEntity;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.httpessentials.types.StructuredMediaType;

public final class XWwwFormUrlEncodedEntity
implements HttpRequestEntity {
    private static final MediaType CONTENT_TYPE = new StructuredMediaType("application", "x-www-form-urlencoded");
    private static final String ENCODING = "UTF-8";
    private final Map.Entry<String, String>[] mValues;

    public XWwwFormUrlEncodedEntity(Map.Entry<String, String> ... values) {
        this.mValues = (Map.Entry[])values.clone();
    }

    public MediaType contentType() {
        return CONTENT_TYPE;
    }

    public long contentLength() throws IOException {
        return this.toString().getBytes(ENCODING).length;
    }

    public void writeContent(OutputStream out) throws IOException {
        out.write(this.toString().getBytes(ENCODING));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.mValues.length * 32);
        boolean first = true;
        for (Map.Entry<String, String> value : this.mValues) {
            if (value == null || value.getKey() == null || value.getKey().isEmpty() || value.getValue() == null) continue;
            if (first) {
                first = false;
            } else {
                builder.append('&');
            }
            builder.append(this.urlEncode(value.getKey()));
            builder.append('=');
            builder.append(this.urlEncode(value.getValue()));
        }
        return builder.toString();
    }

    private String urlEncode(String valueToEncode) {
        try {
            return URLEncoder.encode(valueToEncode, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(String.format("Runtime doesn't support required encoding %s", ENCODING), e);
        }
    }
}

